/*
 * Decompiled with CFR 0.152.
 */
package com.raidspeedruntracker;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.raidspeedruntracker.SpeedRun;
import com.raidspeedruntracker.Split;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import net.runelite.client.RuneLite;

public class RaidSpeedRunFileReadWrite {
    private String username;
    private String dir;

    public void SaveData(List<SpeedRun> speedRuns) {
        try {
            Gson gson = new GsonBuilder().create();
            String fileName = this.dir;
            FileWriter fw = new FileWriter(fileName, false);
            gson.toJson(speedRuns, (Appendable)fw);
            fw.append("\n");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<SpeedRun> LoadData() {
        try {
            Gson gson = new GsonBuilder().create();
            String fileName = this.dir;
            FileReader fr = new FileReader(fileName);
            SpeedRun[] speedRuns = (SpeedRun[])gson.fromJson((Reader)fr, SpeedRun[].class);
            if (speedRuns != null && speedRuns.length >= 0) {
                if (speedRuns.length == 13 && speedRuns[0].getTeamSize() == -1) {
                    fr.close();
                    fr = new FileReader(fileName);
                    speedRuns = new SpeedRun[1];
                    SpeedRun tempSpeedRun = new SpeedRun();
                    tempSpeedRun.setTeamSize(1);
                    Split[] splits = (Split[])gson.fromJson((Reader)fr, Split[].class);
                    tempSpeedRun.setSplits(splits);
                    speedRuns[0] = tempSpeedRun;
                }
                return Arrays.asList(speedRuns);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void createFolder() {
        File dir = new File(RuneLite.RUNELITE_DIR, "speed-run tracker");
        dir.mkdir();
        dir = new File(dir, this.username);
        dir.mkdir();
        File newSpeedRunTrackerFile = new File(dir + "\\speed_run_tracker.log");
        try {
            newSpeedRunTrackerFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.dir = newSpeedRunTrackerFile.getAbsolutePath();
    }

    public void updateUsername(String username) {
        this.username = username;
        this.createFolder();
    }

    public String getUsername() {
        return this.username;
    }
}

