/*
 * Decompiled with CFR 0.152.
 */
package com.dialouge_extractor;

import com.dialouge_extractor.DialogueExtractorConfig;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.InetSocketAddress;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogueExtractorServer
extends WebSocketServer {
    private static final Logger log = LoggerFactory.getLogger(DialogueExtractorServer.class);
    private Gson gson;

    public DialogueExtractorServer(Gson gson, DialogueExtractorConfig config) {
        super(new InetSocketAddress("localhost", config.websocketPort()));
        this.gson = gson;
    }

    @Override
    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        log.debug(conn.getRemoteSocketAddress().getAddress().getHostAddress() + " connected to websocket.");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", "join");
        jsonObject.addProperty("message", "Welcome.");
        conn.send(this.gson.toJson((JsonElement)jsonObject));
    }

    @Override
    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        log.debug(conn.getRemoteSocketAddress().getAddress().getHostAddress() + " closed websocket.");
    }

    @Override
    public void onMessage(WebSocket conn, String message) {
    }

    @Override
    public void onError(WebSocket conn, Exception ex) {
        ex.printStackTrace();
    }

    @Override
    public void onStart() {
    }

    public void send(Object o) {
        String text = this.gson.toJson(o);
        this.broadcast(text);
    }
}

