/*
 * Decompiled with CFR 0.152.
 */
package com.dialouge_extractor;

import com.dialouge_extractor.DialogueExtractorConfig;
import com.dialouge_extractor.DialogueExtractorPanel;
import com.dialouge_extractor.DialogueExtractorServer;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Dialogue Extractor")
public class DialogueExtractorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DialogueExtractorPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private EventBus eventBus;
    @Inject
    private DialogueExtractorConfig config;
    @Inject
    private DialogueExtractorPanel dialogueExtractorPanel;
    @Inject
    private KeyManager keyManager;
    @Inject
    private Gson gson;
    private DialogueExtractorServer websocket;
    private NavigationButton navButton;
    private final KeyListener shiftListener = new KeyListener(){

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getExtendedKeyCode() == 16) {
                DialogueExtractorPlugin.this.dialogueExtractorPanel.setShiftPressed(true);
            }
            if (e.getExtendedKeyCode() == 17) {
                DialogueExtractorPlugin.this.dialogueExtractorPanel.setCtrlPressed(true);
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.getExtendedKeyCode() == 16) {
                DialogueExtractorPlugin.this.dialogueExtractorPanel.setShiftPressed(false);
            }
            if (e.getExtendedKeyCode() == 17) {
                DialogueExtractorPlugin.this.dialogueExtractorPanel.setCtrlPressed(false);
            }
        }
    };

    protected void startUp() throws Exception {
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"normal.png");
        this.navButton = NavigationButton.builder().tooltip("Dialogue Extractor").icon(icon).panel((PluginPanel)this.dialogueExtractorPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.eventBus.register((Object)this.dialogueExtractorPanel);
        this.websocket = new DialogueExtractorServer(this.gson, this.config);
        this.websocket.start();
        this.keyManager.registerKeyListener(this.shiftListener);
        log.debug("Dialogue Extractor started!");
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.eventBus.unregister((Object)this.dialogueExtractorPanel);
        this.keyManager.unregisterKeyListener(this.shiftListener);
        this.websocket.stop();
        log.debug("Dialogue Extractor stopped!");
    }

    public Logger getLogger() {
        return log;
    }

    public DialogueExtractorConfig getConfig() {
        return this.config;
    }

    @Provides
    DialogueExtractorConfig provideConfig(ConfigManager configManager) {
        return (DialogueExtractorConfig)configManager.getConfig(DialogueExtractorConfig.class);
    }

    public DialogueExtractorServer getWebsocket() {
        return this.websocket;
    }
}

