/*
 * Decompiled with CFR 0.152.
 */
package com.dialouge_extractor;

import com.dialouge_extractor.CustomWidgetInfo;
import com.dialouge_extractor.DialogueExtractorPlugin;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DialogueExtractorPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(DialogueExtractorPanel.class);
    private final List<CustomWidgetInfo> messageInfos;
    private final List<CustomWidgetInfo> optionsInfos;
    private final List<CustomWidgetInfo> allInfos;
    private final JLabel uiLabel = new JLabel("Open a dialogue box.");
    private final JLabel serverLabel = new JLabel("Open the dialogue editor.");
    private final Client client;
    private final DialogueExtractorPlugin plugin;
    private JButton[] buttons = new JButton[0];
    private Widget lastWidget;
    private String lastText = "";
    private boolean shiftPressed;
    private boolean ctrlPressed;

    @Inject
    public DialogueExtractorPanel(Client client, DialogueExtractorPlugin plugin) {
        this.messageInfos = Arrays.asList(CustomWidgetInfo.DIALOG_NPC_TEXT, CustomWidgetInfo.DIALOG_PLAYER_TEXT, CustomWidgetInfo.DIALOG_SPRITE_TEXT, CustomWidgetInfo.DIALOG_SPRITE_DOUBLE_TEXT, CustomWidgetInfo.DIALOG_CHATBOX_MESSAGE);
        this.optionsInfos = Arrays.asList(CustomWidgetInfo.DIALOG_OPTION_OPTIONS);
        ArrayList<CustomWidgetInfo> allList = new ArrayList<CustomWidgetInfo>();
        allList.addAll(this.messageInfos);
        allList.addAll(this.optionsInfos);
        this.allInfos = allList;
        this.client = client;
        this.plugin = plugin;
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridLayout(10, 1));
        this.serverLabel.setForeground(Color.WHITE);
        this.uiLabel.setForeground(Color.WHITE);
        this.setVisible(true);
        this.add(this.serverLabel);
        this.add(this.uiLabel);
    }

    private String replace(String dialogue) {
        String username = this.client.getLocalPlayer().getName();
        dialogue = dialogue.replaceAll(username, this.plugin.getConfig().usernameToken());
        if (this.plugin.getConfig().newline()) {
            dialogue = dialogue.replace("<br>", "\n");
        }
        return dialogue;
    }

    private void removeButtons() {
        if (this.buttons.length > 0) {
            for (JButton button : this.buttons) {
                this.remove(button);
            }
            this.buttons = new JButton[0];
        }
    }

    private void setupCopyNormal(Widget widget, CustomWidgetInfo widgetInfo) {
        this.removeButtons();
        this.remove(this.uiLabel);
        try {
            SwingUtilities.invokeAndWait(() -> {
                String title = "";
                switch (widgetInfo) {
                    case DIALOG_PLAYER_TEXT: {
                        title = "<player>";
                        break;
                    }
                    case DIALOG_NPC_TEXT: {
                        title = this.client.getWidget(WidgetInfo.DIALOG_NPC_NAME).getText();
                    }
                }
                JButton copy = new JButton("Copy Dialogue");
                final String dialogue = this.replace(widget.getText());
                copy.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        StringSelection stringSelection = new StringSelection(dialogue);
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        clipboard.setContents(stringSelection, null);
                    }
                });
                this.add(copy);
                this.buttons = new JButton[]{copy};
                this.refresh();
                if (!this.shiftPressed) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("type", "dialogue");
                    jsonObject.addProperty("title", title);
                    jsonObject.addProperty("dialogue", dialogue);
                    jsonObject.addProperty("link", Boolean.valueOf(this.ctrlPressed));
                    this.plugin.getWebsocket().send(jsonObject);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void refresh() {
        this.revalidate();
        this.repaint();
    }

    private void setupCopyOption(Widget option) {
        this.removeButtons();
        this.remove(this.uiLabel);
        try {
            SwingUtilities.invokeAndWait(() -> {
                Widget[] dialogueOptions = option.getChildren();
                String[] optionsText = new String[dialogueOptions.length];
                this.buttons = new JButton[dialogueOptions.length];
                JsonArray jsonArray = new JsonArray();
                for (int i = 0; i < dialogueOptions.length; ++i) {
                    final String option1 = this.replace(dialogueOptions[i].getText());
                    Object info = i == 0 ? "Title" : "Option " + i;
                    JButton copy = new JButton("Copy " + (String)info);
                    copy.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent mouseEvent) {
                            StringSelection stringSelection = new StringSelection(option1);
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clipboard.setContents(stringSelection, null);
                        }
                    });
                    if (option1.length() > 0) {
                        this.add(copy);
                        if (i != 0) {
                            jsonArray.add(option1);
                        }
                    }
                    this.buttons[i] = copy;
                }
                this.refresh();
                JsonObject jsonObject = new JsonObject();
                if (!this.shiftPressed) {
                    jsonObject.addProperty("type", "option");
                    jsonObject.add("options", (JsonElement)jsonArray);
                    jsonObject.addProperty("link", Boolean.valueOf(this.ctrlPressed));
                    this.plugin.getWebsocket().send(jsonObject);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.plugin.getWebsocket().getConnections().size() > 0) {
            this.serverLabel.setText("Dialogue editors connected: " + this.plugin.getWebsocket().getConnections().size());
        } else {
            this.serverLabel.setText("Open the dialogue editor.");
        }
        Widget currentWidget = null;
        CustomWidgetInfo currentWidgetInfo = null;
        String currentText = null;
        for (CustomWidgetInfo widgetInfo : this.allInfos) {
            currentWidget = this.client.getWidget(widgetInfo.groupId, widgetInfo.childId);
            if (currentWidget == null) continue;
            currentWidgetInfo = widgetInfo;
            if (this.messageInfos.contains((Object)currentWidgetInfo)) {
                currentText = currentWidget.getText();
                break;
            }
            if (!this.optionsInfos.contains((Object)currentWidgetInfo)) break;
            currentText = Arrays.stream(currentWidget.getChildren()).map(Widget::getText).collect(Collectors.joining("\n"));
            break;
        }
        if (currentWidget != null) {
            if (currentWidget != this.lastWidget || !this.lastText.equals(currentText)) {
                this.lastWidget = currentWidget;
                this.lastText = currentText;
                if (this.messageInfos.contains((Object)currentWidgetInfo)) {
                    this.setupCopyNormal(currentWidget, currentWidgetInfo);
                } else if (this.optionsInfos.contains((Object)currentWidgetInfo)) {
                    this.setupCopyOption(currentWidget);
                }
            }
        } else if (this.lastWidget != null) {
            this.removeButtons();
            this.add(this.uiLabel);
            this.refresh();
        }
    }

    public void setCtrlPressed(boolean ctrlPressed) {
        this.ctrlPressed = ctrlPressed;
    }

    public void setShiftPressed(boolean shiftPressed) {
        this.shiftPressed = shiftPressed;
    }
}

