/*
 * Decompiled with CFR 0.152.
 */
package com.noexamine;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.noexamine.NoExamineConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.MenuOpened;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="No Examine", description="Remove examine menu options to never missclick again", tags={"examine", "missclick"})
public class NoExaminePlugin
extends Plugin {
    private static final String EXAMINE = "Examine";
    private static final String REMOVE = "Remove";
    private static final int POH_BUILDING_MODE_VARBIT = 2176;
    private static final Set<Integer> POH_REGION_IDS = new HashSet<Integer>(Arrays.asList(7258, 7514, 7770, 8026, 7257, 7513, 7769, 8025));
    @Inject
    private Client client;
    @Inject
    private NoExamineConfig config;

    @Provides
    NoExamineConfig provideConfig(ConfigManager configManager) {
        return (NoExamineConfig)configManager.getConfig(NoExamineConfig.class);
    }

    @Subscribe(priority=-1.0f)
    public void onMenuOpened(MenuOpened event) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        ArrayList<MenuEntry> alteredMenuEntries = new ArrayList<MenuEntry>();
        for (MenuEntry menuEntry : menuEntries) {
            MenuAction menuAction = menuEntry.getType();
            if (this.isExamine(menuAction, menuEntry.getOption()) || this.isCancel(menuAction) || this.isRemove(menuAction, menuEntry.getOption()) || this.isWalkHere(menuAction)) continue;
            alteredMenuEntries.add(menuEntry);
        }
        this.client.setMenuEntries(alteredMenuEntries.toArray(new MenuEntry[0]));
    }

    private boolean isExamine(MenuAction menuAction, String option) {
        if (this.client.isKeyPressed(81) && this.config.examineShift()) {
            return false;
        }
        return MenuAction.EXAMINE_ITEM_GROUND.equals((Object)menuAction) && this.config.examineItemsGround() || MenuAction.EXAMINE_NPC.equals((Object)menuAction) && this.config.examineNpcs() || MenuAction.EXAMINE_OBJECT.equals((Object)menuAction) && this.config.examineObjects() || MenuAction.CC_OP_LOW_PRIORITY.equals((Object)menuAction) && this.config.examineItemInventory() && EXAMINE.equals(option);
    }

    private boolean isPoh() {
        return this.client.getVarbitValue(2176) != 1 && POH_REGION_IDS.contains(WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID());
    }

    private boolean isCancel(MenuAction menuAction) {
        return MenuAction.CANCEL.equals((Object)menuAction) && this.config.cancelEverywhere();
    }

    private boolean isRemove(MenuAction menuAction, String option) {
        return this.isPoh() && MenuAction.GAME_OBJECT_FIFTH_OPTION.equals((Object)menuAction) && REMOVE.equals(option) && this.config.removePoh();
    }

    private boolean isWalkHere(MenuAction menuAction) {
        return MenuAction.WALK.equals((Object)menuAction) && this.config.walkHereEverywhere();
    }
}

