/*
 * Decompiled with CFR 0.152.
 */
package com.queuehelper;

import com.queuehelper.BASHTTPClient;
import com.queuehelper.BASPlugin;
import com.queuehelper.BasQueuePanel;
import com.queuehelper.Customer;
import com.queuehelper.QueueHelperHTTPClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.ui.NavigationButton;
import okhttp3.OkHttpClient;

public class Queue {
    private static Queue queue;
    private boolean shouldUpdateQueue;
    private BasQueuePanel basPanel;
    private OkHttpClient RLhttpclient;
    Customer tempNext;
    boolean first = true;
    private LinkedHashMap<String, Customer> CurrentQueue;
    private List<String[]> OldQueue;
    private QueueHelperHTTPClient httpClient;
    Timer timer;
    TimerTask updateQueue;
    BASPlugin plugin;

    private Queue(String apikey, BasQueuePanel BasPanel, BASPlugin Plugin2, OkHttpClient rlhttp) throws IOException {
        this.plugin = Plugin2;
        this.RLhttpclient = rlhttp;
        this.basPanel = BasPanel;
        this.timer = new Timer();
        this.shouldUpdateQueue = false;
        this.CurrentQueue = new LinkedHashMap();
        this.httpClient = BASHTTPClient.getInstance(apikey, this.RLhttpclient);
        this.OldQueue = new ArrayList<String[]>();
        this.createQueue();
        this.updateQueue = new TimerTask(){

            @Override
            public void run() {
                Queue.this.updateQueueTask(Queue.this.ShouldUpdate());
            }
        };
        this.timer.scheduleAtFixedRate(this.updateQueue, new Date(), 120000L);
    }

    public static Queue getInstance(String apikey, BasQueuePanel BasPanel, BASPlugin basPlugin, OkHttpClient rlhttp) throws IOException {
        if (queue == null) {
            queue = new Queue(apikey, BasPanel, basPlugin, rlhttp);
        } else {
            queue.setAPikey(apikey);
        }
        return queue;
    }

    public boolean ShouldUpdate() {
        return this.shouldUpdateQueue;
    }

    public void ShouldUpdate(boolean ShouldUpdateQueue) {
        this.shouldUpdateQueue = ShouldUpdateQueue;
    }

    private void setAPikey(String apikey) throws IOException {
        this.httpClient = BASHTTPClient.getInstance(apikey, this.RLhttpclient);
    }

    public boolean doesCustExist(String name) {
        return this.CurrentQueue.containsKey(name);
    }

    private void createQueue() throws IOException {
        this.OldQueue = this.httpClient.readCSV(this.OldQueue);
        for (String[] CSVLine : this.OldQueue) {
            this.CurrentQueue.put(CSVLine[1], new Customer(CSVLine[1], CSVLine[3], CSVLine[0], CSVLine[2], CSVLine[5], CSVLine[4]));
        }
    }

    public NavigationButton getNav() {
        return this.httpClient.getNavButton();
    }

    public LinkedHashMap<String, Customer> getQueue() {
        return this.CurrentQueue;
    }

    public Customer getNext() {
        for (Customer cust : this.CurrentQueue.values()) {
            if (cust.getStatus().equals("Online") && cust.getPriority().equals("P") && !cust.getNotes().toLowerCase().contains("cooldown")) {
                return cust;
            }
            if (!cust.getStatus().equals("Online") || !cust.getPriority().equals("R") || cust.getNotes().toLowerCase().contains("cooldown") || !this.first) continue;
            this.first = false;
            this.tempNext = cust;
        }
        this.first = true;
        return this.tempNext;
    }

    public void refresh() throws IOException {
        this.CurrentQueue.clear();
        this.createQueue();
    }

    public void mark(int option, Customer cust) throws IOException {
        this.httpClient.markCustomer(option, cust.getName());
    }

    private void updateQueueTask(boolean shouldUpdateQueue) {
        if (shouldUpdateQueue) {
            try {
                this.plugin.updateQueue();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.shouldUpdateQueue = false;
        }
        try {
            this.createQueue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(() -> this.basPanel.populate(queue.getQueue()));
    }

    public boolean addToQueue(String itemName, String priority, String custName, String addedBy) {
        try {
            return this.httpClient.addCustomer(itemName, priority, custName, addedBy);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void updateQueuebackend(StringBuilder urlList, String name) throws IOException {
        this.httpClient.updateQueuebackend(urlList, name);
    }

    public void sendChatMsgDiscord(ChatMessage chatMessage) {
        try {
            this.httpClient.sendChatMsgDiscord(chatMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

