/*
 * Decompiled with CFR 0.152.
 */
package com.queuehelper;

import com.queuehelper.BASPlugin;
import com.queuehelper.Customer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;

class BasQueueRow
extends JPanel {
    private final JMenuItem addMenuOption = new JMenuItem();
    private boolean otherimg = false;
    private JLabel nameField;
    private JLabel idField;
    private JLabel itemField;
    private JTextArea notesField;
    public Customer customer;
    private Color lastBackground;
    private BASPlugin plugin;
    private JLabel item;

    BasQueueRow(Customer Customer2, BASPlugin Plugin2) {
        int option;
        String menuText;
        this.customer = Customer2;
        this.plugin = Plugin2;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        String tooltipHover = "";
        if (this.customer.getStatus().equals("")) {
            menuText = "Mark " + this.customer.getName() + " online";
            option = 3;
            tooltipHover = "Offline";
        } else if (this.customer.getNotes().toLowerCase().contains("cooldown")) {
            menuText = "End Cooldown for: " + this.customer.getName() + "(Currently unavailable)";
            option = 0;
            tooltipHover = "Cooldown";
        } else if (this.customer.getStatus().equals("In Progress")) {
            if (this.customer.getItem().equals("Level 5 Roles") && (this.customer.getNotes().contains("d started") || this.customer.getNotes().contains("2/3"))) {
                menuText = "Mark " + this.customer.getName() + " done";
                option = 2;
                tooltipHover = "In Progress last session lvl5s";
            } else if (this.customer.getItem().equals("Level 5 Roles")) {
                menuText = "Start Cooldown for: " + this.customer.getName();
                option = 4;
                tooltipHover = "In Progress lvl5s";
            } else {
                menuText = "Mark " + this.customer.getName() + " done";
                option = 2;
                tooltipHover = "In Progress";
            }
        } else if (this.customer.getStatus().equals("Done")) {
            menuText = "Mark " + this.customer.getName() + " in progress";
            option = 1;
            tooltipHover = "Done";
        } else {
            menuText = "Mark " + this.customer.getName() + " in progress";
            option = 1;
            tooltipHover = "Online";
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BasQueueRow.this.plugin.markCustomer(option, BasQueueRow.this.customer);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BasQueueRow.this.setBackground(BasQueueRow.this.getBackground().brighter());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BasQueueRow.this.setBackground(BasQueueRow.this.getBackground().darker());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                BasQueueRow.this.lastBackground = BasQueueRow.this.getBackground();
                BasQueueRow.this.setBackground(BasQueueRow.this.getBackground().brighter());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                BasQueueRow.this.setBackground(BasQueueRow.this.lastBackground);
            }
        });
        this.addMenuOption.setText(menuText);
        for (ActionListener listener : this.addMenuOption.getActionListeners()) {
            this.addMenuOption.removeActionListener(listener);
        }
        this.addMenuOption.addActionListener(e -> this.plugin.markCustomer(option, this.customer));
        popupMenu.add(this.addMenuOption);
        this.setComponentPopupMenu(popupMenu);
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        leftSide.setOpaque(false);
        rightSide.setOpaque(false);
        JPanel nameField = this.buildNameField(Customer2);
        nameField.setPreferredSize(new Dimension(70, 10));
        nameField.setOpaque(false);
        JPanel idField = this.buildidField(Customer2);
        idField.setPreferredSize(new Dimension(30, 10));
        idField.setOpaque(false);
        JPanel itemField = this.builditemField(Customer2);
        itemField.setPreferredSize(new Dimension(30, 30));
        itemField.setOpaque(false);
        JPanel notesField = this.buildNotesField(Customer2);
        notesField.setPreferredSize(new Dimension(5, 34));
        notesField.setOpaque(false);
        this.recolour(Customer2);
        leftSide.add((Component)idField, "West");
        leftSide.add((Component)nameField, "Center");
        rightSide.add((Component)itemField, "West");
        rightSide.add((Component)notesField, "Center");
        this.add((Component)leftSide, "West");
        this.add((Component)rightSide, "Center");
        this.setToolTipText(tooltipHover);
    }

    public void recolour(Customer customer) {
        String status = customer.getStatus();
        Color curColor = Color.black;
        if (this.item == null) {
            this.itemField.setForeground(curColor);
        }
        this.notesField.setForeground(curColor);
        this.nameField.setForeground(curColor);
        this.idField.setForeground(curColor);
        switch (status) {
            case "Online": {
                if (!customer.getNotes().toLowerCase().contains("cd") && !customer.getNotes().toLowerCase().contains("cooldown")) {
                    curColor = Color.green;
                    if (this.item == null) {
                        this.itemField.setForeground(curColor);
                    }
                    this.notesField.setForeground(curColor);
                    this.nameField.setForeground(curColor);
                    this.idField.setForeground(curColor);
                    break;
                }
                curColor = new Color(99, 151, 255);
                this.setBackground(curColor);
                this.notesField.setBackground(curColor);
                break;
            }
            case "In Progress": {
                curColor = new Color(241, 235, 118);
                this.setBackground(curColor);
                this.notesField.setBackground(curColor);
                break;
            }
            case "Done": {
                curColor = new Color(129, 129, 129);
                this.setBackground(curColor);
                this.notesField.setBackground(curColor);
                break;
            }
            case "": {
                if (!customer.getNotes().toLowerCase().contains("cd") && !customer.getNotes().toLowerCase().contains("cooldown")) {
                    curColor = Color.red;
                    if (this.item == null) {
                        this.itemField.setForeground(curColor);
                    }
                    this.notesField.setForeground(curColor);
                    this.nameField.setForeground(curColor);
                    this.idField.setForeground(curColor);
                    break;
                }
                curColor = new Color(99, 151, 255);
                this.setBackground(curColor);
                break;
            }
            default: {
                curColor = Color.gray;
                this.setBackground(curColor);
            }
        }
    }

    private JPanel builditemField(Customer cust) {
        String item = cust.getItem();
        JPanel column = new JPanel(new BorderLayout());
        switch (item) {
            case "Torso": {
                column = new JPanel(new BorderLayout());
                this.itemField = new JLabel(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)"/torso.png")));
                column.add(this.itemField);
                return column;
            }
            case "Queen Kill - Diary": {
                column = new JPanel(new BorderLayout());
                this.itemField = new JLabel(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)"/queen_kill.png")));
                column.add(this.itemField);
                return column;
            }
            case "Level 5 Roles": {
                column = new JPanel(new BorderLayout());
                this.itemField = new JLabel(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)"/Level5s.png")));
                column.add(this.itemField);
                return column;
            }
            case "Hat": {
                column = new JPanel(new BorderLayout());
                this.itemField = new JLabel(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)"/hat4.png")));
                column.add(this.itemField);
                return column;
            }
        }
        if (item.toLowerCase().contains("gamble")) {
            column = new JPanel(new BorderLayout());
            this.itemField = new JLabel(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)"/Other.png")));
            column.add(this.itemField);
            return column;
        }
        if (item.toLowerCase().contains("points") || item.toLowerCase().contains("pts")) {
            column = new JPanel(new BorderLayout());
            this.itemField = new JLabel(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)"/points.png")));
            this.otherimg = true;
            column.add(this.itemField);
            return column;
        }
        column = new JPanel(new BorderLayout());
        this.itemField = new JLabel(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)"/Other.png")));
        column.add(this.itemField);
        this.otherimg = true;
        return column;
    }

    private JPanel buildidField(Customer cust) {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.idField = new JLabel(cust.getID());
        this.idField.setFont(FontManager.getRunescapeSmallFont().deriveFont(8));
        this.idField.setToolTipText(cust.getID());
        this.idField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BasQueueRow.this.dispatchEvent(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                BasQueueRow.this.dispatchEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BasQueueRow.this.dispatchEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BasQueueRow.this.dispatchEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BasQueueRow.this.dispatchEvent(e);
            }
        });
        column.add((Component)this.idField, "East");
        return column;
    }

    private JPanel buildNotesField(Customer cust) {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        Object activity = cust.getNotes();
        if (this.otherimg) {
            activity = cust.getItem() + " " + cust.getNotes();
        }
        this.notesField = new JTextArea(2, 10);
        this.notesField.setText((String)activity);
        this.notesField.setLineWrap(true);
        this.notesField.setWrapStyleWord(true);
        this.notesField.setEditable(true);
        this.notesField.setOpaque(false);
        this.notesField.setFont(FontManager.getRunescapeSmallFont().deriveFont(this.plugin.fontSize));
        column.add((Component)this.notesField, "West");
        return column;
    }

    private JPanel buildNameField(Customer cust) {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.nameField = new JLabel(cust.getName());
        this.nameField.setFont(FontManager.getRunescapeSmallFont());
        column.add((Component)this.nameField, "Center");
        return column;
    }
}

