/*
 * Decompiled with CFR 0.152.
 */
package com.queuehelper;

import com.queuehelper.AutoComplete;
import com.queuehelper.BASConfig;
import com.queuehelper.BASPlugin;
import com.queuehelper.BasQueueRow;
import com.queuehelper.ComboBoxIconEntry;
import com.queuehelper.ComboBoxIconListRenderer;
import com.queuehelper.Customer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;

public class BasQueuePanel
extends PluginPanel {
    private BASPlugin plugin;
    private final JPanel onlistContainer;
    private final JPanel offlistContainer;
    private ArrayList<BasQueueRow> rows;
    private BASConfig config;
    private JButton nextButton;
    private JButton custButton;
    private JTextArea namearea;
    private JPanel nextRefreshArea;
    private JPanel custPrioArea;
    private String currItem;
    private String currPriority;
    private JPanel nameAreaPanel;
    private JButton viewOnlineQueue;
    AutoComplete autoComplete;
    private final JPanel display = new JPanel();
    private final MaterialTabGroup tabGroup = new MaterialTabGroup(this.display);
    ArrayList<String> keywords = new ArrayList();

    BasQueuePanel(BASPlugin plugin, BASConfig Config2) {
        this.plugin = plugin;
        this.config = Config2;
        this.rows = new ArrayList();
        this.onlistContainer = new JPanel();
        this.offlistContainer = new JPanel();
        this.setBorder(null);
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        this.onlistContainer.setLayout(new GridLayout(0, 1));
        this.offlistContainer.setLayout(new GridLayout(0, 1));
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        MaterialTab offersTab = new MaterialTab("Online", this.tabGroup, (JComponent)this.onlistContainer);
        MaterialTab searchTab = new MaterialTab("Offline", this.tabGroup, (JComponent)this.offlistContainer);
        this.tabGroup.setBorder((Border)new EmptyBorder(5, 0, 0, 0));
        this.tabGroup.addTab(offersTab);
        this.tabGroup.addTab(searchTab);
        this.tabGroup.select(offersTab);
        this.add((Component)this.tabGroup, "North");
        this.add(this.display, "Center");
        this.nextRefreshArea = this.refreshNextButton();
        this.nameAreaPanel = this.customerNamePrioPanel();
        this.custPrioArea = this.customerAddPanel();
        this.viewOnlineQueue = new JButton("View Online Queue");
        this.viewOnlineQueue.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.viewOnlineQueue.setBorder(new EmptyBorder(5, 7, 5, 7));
        this.viewOnlineQueue.addActionListener(e -> LinkBrowser.browse((String)"https://baservices.site/ranksqueue/"));
    }

    public void setAutoCompleteKeyWords(ArrayList<String> Keywords) {
        this.autoComplete.setKeyWords(Keywords);
        this.keywords = Keywords;
    }

    void populate(LinkedHashMap<String, Customer> queue) {
        this.rows.clear();
        this.offlistContainer.removeAll();
        this.onlistContainer.removeAll();
        for (Customer cust : queue.values()) {
            this.rows.add(new BasQueueRow(cust, this.plugin));
        }
        for (BasQueueRow row : this.rows) {
            if (row.customer.getStatus().equals("Online") || row.customer.getStatus().equals("In Progress")) {
                this.onlistContainer.add(row);
                continue;
            }
            this.offlistContainer.add(row);
        }
        this.onlistContainer.add(this.nextRefreshArea);
        this.onlistContainer.add(this.nameAreaPanel);
        this.onlistContainer.add(this.custPrioArea);
        this.onlistContainer.add(this.viewOnlineQueue);
    }

    private JPanel addRefreshButton(String label) {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        JButton resetButton = new JButton(label);
        resetButton.setBackground(ColorScheme.DARK_GRAY_COLOR);
        resetButton.setBorder(new EmptyBorder(5, 0, 5, 5));
        resetButton.setToolTipText("refreshes the online Queue and redraws it");
        resetButton.setEnabled(true);
        resetButton.addActionListener(e -> this.plugin.refreshQueue());
        container.add((Component)resetButton, "Center");
        return container;
    }

    private JPanel addNextButton(String label) {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        this.nextButton = new JButton(label);
        this.nextButton.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nextButton.setBorder(new EmptyBorder(5, 5, 5, 7));
        this.nextButton.addActionListener(e -> this.plugin.getNext());
        container.add((Component)this.nextButton, "Center");
        return container;
    }

    private JComboBox<ComboBoxIconEntry> createCombobox() {
        JComboBox<ComboBoxIconEntry> dropdown = new JComboBox<ComboBoxIconEntry>();
        dropdown.setFocusable(false);
        dropdown.setForeground(Color.WHITE);
        dropdown.setMaximumRowCount(5);
        ComboBoxIconListRenderer renderer = new ComboBoxIconListRenderer();
        renderer.setDefaultText("Select an Item...");
        dropdown.setRenderer(renderer);
        BufferedImage torsoimg = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/torso.png");
        ComboBoxIconEntry torsoentry = new ComboBoxIconEntry(new ImageIcon(torsoimg), "Torso");
        BufferedImage lvl5img = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/Level5s.png");
        ComboBoxIconEntry lvl5entry = new ComboBoxIconEntry(new ImageIcon(lvl5img), "Level 5 Roles");
        BufferedImage pointsimg = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/points.png");
        ComboBoxIconEntry pointsentry = new ComboBoxIconEntry(new ImageIcon(pointsimg), "One Round - Points");
        BufferedImage qkimg = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/queen_kill.png");
        ComboBoxIconEntry qkentry = new ComboBoxIconEntry(new ImageIcon(qkimg), "Queen Kill - Diary");
        BufferedImage hatimg = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/hat4.png");
        ComboBoxIconEntry hatentry = new ComboBoxIconEntry(new ImageIcon(hatimg), "Hat");
        dropdown.addItem(torsoentry);
        dropdown.addItem(lvl5entry);
        dropdown.addItem(pointsentry);
        dropdown.addItem(qkentry);
        dropdown.addItem(hatentry);
        dropdown.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                ComboBoxIconEntry source = (ComboBoxIconEntry)e.getItem();
                this.currItem = source.getText();
            }
        });
        dropdown.setSelectedIndex(-1);
        return dropdown;
    }

    private JTextArea customerNamePanel() {
        this.namearea = new JTextArea(1, 10);
        this.namearea.setFocusTraversalKeysEnabled(false);
        this.namearea.setText("Customer");
        this.namearea.setLineWrap(true);
        this.namearea.setWrapStyleWord(true);
        this.namearea.setEditable(true);
        this.namearea.setOpaque(true);
        this.namearea.addFocusListener(this.custAreaFocus());
        this.namearea.setBorder(new EmptyBorder(20, 20, 2, 20));
        String COMMIT_ACTION = "commit";
        this.keywords.add("Skyler Miner");
        this.autoComplete = new AutoComplete(this.namearea, this.keywords);
        this.namearea.getDocument().addDocumentListener(this.autoComplete);
        this.namearea.getInputMap().put(KeyStroke.getKeyStroke("TAB"), COMMIT_ACTION);
        this.namearea.getActionMap().put(COMMIT_ACTION, this.autoComplete.new AutoComplete.CommitAction());
        return this.namearea;
    }

    private JPanel addCustomerButoon(String label) {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        this.custButton = new JButton(label);
        this.custButton.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.custButton.setBorder(new EmptyBorder(5, 7, 5, 7));
        this.custButton.addActionListener(e -> this.addCustomerAction());
        container.add((Component)this.custButton, "Center");
        return container;
    }

    public void changeCustomerText(String name) {
        this.namearea = (JTextArea)this.nameAreaPanel.getComponent(0);
        this.namearea.setText(name);
    }

    private void addCustomerAction() {
        this.namearea = (JTextArea)this.nameAreaPanel.getComponent(0);
        try {
            this.plugin.addToQueue(this.namearea.getText(), this.currItem, this.currPriority);
            this.namearea.setText("Customer");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FocusListener custAreaFocus() {
        FocusListener focus = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (BasQueuePanel.this.namearea.getText().equals("Customer")) {
                    BasQueuePanel.this.namearea = (JTextArea)BasQueuePanel.this.nameAreaPanel.getComponent(0);
                    BasQueuePanel.this.namearea.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (BasQueuePanel.this.namearea.getText().equals("")) {
                    BasQueuePanel.this.namearea = (JTextArea)BasQueuePanel.this.nameAreaPanel.getComponent(0);
                    BasQueuePanel.this.namearea.setText("Customer");
                }
            }
        };
        return focus;
    }

    private JPanel customerAddPanel() {
        JComboBox<ComboBoxIconEntry> dropdown = this.createCombobox();
        JPanel custButton = this.addCustomerButoon("Add Customer");
        JPanel addPanel = new JPanel();
        addPanel.setLayout(new BorderLayout());
        addPanel.setBorder(new EmptyBorder(3, 0, 2, 5));
        addPanel.add(dropdown, "Center");
        addPanel.add((Component)custButton, "East");
        return addPanel;
    }

    private JPanel customerNamePrioPanel() {
        JComboBox<ComboBoxIconEntry> dropdown = this.createRegPremSelect();
        JPanel addPanel = new JPanel();
        addPanel.setLayout(new BorderLayout());
        this.customerNamePanel();
        addPanel.setBorder(new EmptyBorder(3, 0, 2, 5));
        addPanel.add((Component)this.namearea, "Center");
        addPanel.add(dropdown, "East");
        return addPanel;
    }

    private JPanel refreshNextButton() {
        JPanel combined = new JPanel();
        JPanel next = this.addNextButton("Next");
        JPanel refresh = this.addRefreshButton("Refresh");
        combined.setLayout(new BorderLayout());
        combined.setBorder(new EmptyBorder(3, 0, 2, 5));
        combined.add((Component)next, "Center");
        combined.add((Component)refresh, "East");
        return combined;
    }

    private JComboBox<ComboBoxIconEntry> createRegPremSelect() {
        JComboBox<ComboBoxIconEntry> dropdown = new JComboBox<ComboBoxIconEntry>();
        dropdown.setFocusable(false);
        dropdown.setForeground(Color.WHITE);
        dropdown.setMaximumRowCount(5);
        ComboBoxIconListRenderer renderer = new ComboBoxIconListRenderer();
        renderer.setDefaultText("Priority");
        dropdown.setRenderer(renderer);
        BufferedImage regimg = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/torso.png");
        ComboBoxIconEntry regentry = new ComboBoxIconEntry(new ImageIcon(regimg), "Regular");
        BufferedImage premimg = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/torso.png");
        ComboBoxIconEntry prementry = new ComboBoxIconEntry(new ImageIcon(premimg), "Premium");
        dropdown.addItem(regentry);
        dropdown.addItem(prementry);
        dropdown.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                ComboBoxIconEntry source = (ComboBoxIconEntry)e.getItem();
                this.currPriority = source.getText();
            }
        });
        dropdown.setSelectedIndex(-1);
        return dropdown;
    }
}

