/*
 * Decompiled with CFR 0.152.
 */
package com.queuehelper;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import com.queuehelper.BASConfig;
import com.queuehelper.BASHTTPClient;
import com.queuehelper.BasQueuePanel;
import com.queuehelper.Customer;
import com.queuehelper.Queue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatManager;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.FriendsChatRank;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.FriendsChatMemberJoined;
import net.runelite.api.events.FriendsChatMemberLeft;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.Text;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="BAS Queue Helper", description="BAS Customer CC Info", tags={"minigame"})
public class BASPlugin
extends Plugin
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(BASPlugin.class);
    private static final String ccName = "Ba\u00a0Services";
    private static final String errorMsg = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("BAS QH: ").append(ChatColorType.HIGHLIGHT).append("Please Paste the API key in the plugin settings and restart the plugin").build();
    private BasQueuePanel basQueuePanel;
    private NavigationButton navButton;
    public float fontSize;
    private boolean msgIn = false;
    private static final String KICK_OPTION = "Kick";
    private static final ImmutableList<String> BEFORE_OPTIONS = ImmutableList.of((Object)"Add friend", (Object)"Remove friend", (Object)"Kick");
    private static final ImmutableList<String> AFTER_OPTIONS = ImmutableList.of((Object)"Message");
    private BASHTTPClient httpclient;
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private BASConfig config;
    @Inject
    private OkHttpClient BasHttpClient;
    @Inject
    private ClientToolbar clientToolbar;
    private Queue queue;

    @Provides
    BASConfig provideConfig(ConfigManager configManager) {
        return (BASConfig)configManager.getConfig(BASConfig.class);
    }

    protected void startUp() throws Exception {
        if (!this.isConfigApiEmpty()) {
            this.basQueuePanel = new BasQueuePanel(this, this.config);
            this.queue = Queue.getInstance(this.config.apikey(), this.basQueuePanel, this, this.BasHttpClient);
            this.navButton = this.queue.getNav();
            this.navButton.setPanel((PluginPanel)this.basQueuePanel);
            this.clientToolbar.addNavigation(this.navButton);
            SwingUtilities.invokeLater(() -> this.basQueuePanel.populate(this.queue.getQueue()));
            this.fontSize = this.config.fontSize();
        }
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.queue = null;
        this.httpclient = null;
    }

    private boolean isConfigApiEmpty() {
        if (this.config.apikey().equals("Paste your key here") || this.config.apikey().equals("")) {
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(errorMsg).build());
            this.client.getAccountHash();
            return true;
        }
        return false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) throws IOException {
        this.fontSize = this.config.fontSize();
    }

    @Subscribe
    public void onFriendsChatMemberJoined(FriendsChatMemberJoined event) throws IOException {
        this.queue.ShouldUpdate(true);
    }

    @Subscribe
    public void onFriendsChatMemberLeft(FriendsChatMemberLeft event) throws IOException {
        this.queue.ShouldUpdate(true);
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (event.getMenuEntries().length < 2) {
            return;
        }
        MenuEntry entry = event.getMenuEntries()[event.getMenuEntries().length - 2];
        if (entry.getType() != MenuAction.CC_OP_LOW_PRIORITY && entry.getType() != MenuAction.RUNELITE) {
            return;
        }
        int groupId = WidgetInfo.TO_GROUP((int)entry.getParam1());
        int childId = WidgetInfo.TO_CHILD((int)entry.getParam1());
        if (groupId != WidgetInfo.CHATBOX.getGroupId()) {
            return;
        }
        Widget widget = this.client.getWidget(groupId, childId);
        Widget parent = widget.getParent();
        if (WidgetInfo.CHATBOX_MESSAGE_LINES.getId() != parent.getId()) {
            return;
        }
        int first = WidgetInfo.CHATBOX_FIRST_MESSAGE.getChildId();
        int dynamicChildId = (childId - first) * 4;
        Widget messageContents = parent.getChild(dynamicChildId);
        if (messageContents == null) {
            return;
        }
        String playerName = messageContents.getText();
        String player = playerName.replaceAll("\\[.*\\]", "").trim().replace(":", "");
        this.client.createMenuEntry(1).setOption("Add to Queue Sidepanel").setTarget(entry.getTarget()).setType(MenuAction.RUNELITE).onClick(e -> this.basQueuePanel.changeCustomerText(Text.removeTags((String)Text.toJagexName((String)player))));
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        int componentId = event.getActionParam1();
        int groupId = WidgetInfo.TO_GROUP((int)componentId);
        String option = event.getOption();
        if (groupId == WidgetInfo.FRIENDS_LIST.getGroupId() || groupId == WidgetInfo.FRIENDS_CHAT.getGroupId() || componentId == WidgetInfo.CLAN_MEMBER_LIST.getId() || componentId == WidgetInfo.CLAN_GUEST_MEMBER_LIST.getId()) {
            boolean after;
            if (AFTER_OPTIONS.contains((Object)option)) {
                after = true;
            } else if (BEFORE_OPTIONS.contains((Object)option)) {
                after = false;
            } else {
                return;
            }
            this.client.createMenuEntry(after ? -2 : -1).setOption("Add to Queue Sidepanel").setTarget(event.getTarget()).setType(MenuAction.RUNELITE).onClick(e -> this.basQueuePanel.changeCustomerText(Text.removeTags((String)Text.toJagexName((String)event.getTarget())).replaceAll("\\[.*\\]", "").trim().replace(":", "")));
        }
    }

    private boolean isRank() {
        FriendsChatManager clanMemberManager = this.client.getFriendsChatManager();
        return this.client.getLocalPlayer().getName() != null && clanMemberManager != null && clanMemberManager.getCount() >= 1 && clanMemberManager.getOwner().equals(ccName);
    }

    public void updateQueue() throws IOException {
        if (!this.isRank()) {
            return;
        }
        FriendsChatManager clanMemberManager = this.client.getFriendsChatManager();
        if (!this.config.autoUpdateQueue() || clanMemberManager == null) {
            return;
        }
        StringBuilder csv = new StringBuilder();
        for (FriendsChatMember member : (FriendsChatMember[])clanMemberManager.getMembers()) {
            String memberName = member.getName();
            if (csv.toString().equals("")) {
                csv = new StringBuilder(memberName + "#" + member.getRank().getValue());
                continue;
            }
            csv.append(",").append(memberName).append("#").append(member.getRank().getValue());
        }
        if (csv.toString().equals("")) {
            return;
        }
        if (this.isConfigApiEmpty()) {
            return;
        }
        String name = this.config.queueName();
        if (this.client.getLocalPlayer().getName() != null) {
            name = Text.sanitize((String)this.client.getLocalPlayer().getName());
        }
        this.queue.updateQueuebackend(csv, name);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        int numMsg;
        if (!this.isRank() || chatMessage.getType() != ChatMessageType.FRIENDSCHAT) {
            return;
        }
        FriendsChatRank rank = this.getRank(chatMessage.getName());
        if (this.isConfigApiEmpty()) {
            return;
        }
        try {
            numMsg = chatMessage.getMessage().charAt(0);
            if (48 <= numMsg && numMsg <= 53 && (chatMessage.getMessage().contains("out") || chatMessage.getMessage().contains("f") || chatMessage.getMessage().contains("a") || chatMessage.getMessage().contains("*") || chatMessage.getMessage().contains("c") || chatMessage.getMessage().contains("d") || chatMessage.getMessage().contains("h") || chatMessage.getMessage().contains("r") && !chatMessage.getMessage().contains("reg"))) {
                this.msgIn = '0' > chatMessage.getMessage().charAt(1) || chatMessage.getMessage().charAt(1) > '9';
            }
        }
        catch (NumberFormatException ex) {
            log.debug("Normal behavior");
        }
        try {
            numMsg = Integer.parseInt(chatMessage.getMessage());
            if (0 <= numMsg && numMsg <= 5) {
                this.msgIn = true;
            }
        }
        catch (NumberFormatException ex) {
            log.debug("Normal behavior");
        }
        if (chatMessage.getMessage().toLowerCase().contains("t+") || chatMessage.getMessage().toLowerCase().contains("-=-=") || chatMessage.getMessage().toLowerCase().contains("---") || chatMessage.getMessage().toLowerCase().contains("===") || chatMessage.getMessage().toLowerCase().equals("jf") || chatMessage.getMessage().toLowerCase().equals("out")) {
            this.msgIn = true;
        }
        if ((chatMessage.getMessage().contains("+") && chatMessage.getMessage().charAt(0) == '+' || this.msgIn) && !chatMessage.getMessage().toLowerCase().contains("@")) {
            this.msgIn = false;
            this.queue.sendChatMsgDiscord(chatMessage);
        }
    }

    private FriendsChatRank getRank(String playerName) {
        FriendsChatManager friendsChatManager = this.client.getFriendsChatManager();
        if (friendsChatManager == null) {
            return FriendsChatRank.UNRANKED;
        }
        FriendsChatMember friendsChatMember = (FriendsChatMember)friendsChatManager.findByName(playerName);
        return friendsChatMember != null ? friendsChatMember.getRank() : FriendsChatRank.UNRANKED;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void getNext() {
        Customer next = this.queue.getNext();
        if (next == null) {
            this.sendChat("queue empty");
            return;
        }
        this.sendChat("Next customer in line: Priority " + next.getPriority() + " " + next.getName() + " " + next.getItem() + " " + next.getNotes());
    }

    public void sendChat(String msg) {
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(msg).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
    }

    public void addToQueue(String name, String item, String priority) {
        if (name.equals("Customer")) {
            this.sendChat("Please enter a name");
            return;
        }
        if (this.queue.addToQueue(item, priority, name, this.config.queueName())) {
            this.sendChat("Added: " + name + " for " + priority + " " + item);
        } else {
            this.sendChat("Failed to add: " + name + " for " + priority + " " + item);
        }
        this.refreshQueue();
    }

    public void refreshQueue() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            FriendsChatManager clanMemberManager = this.client.getFriendsChatManager();
            FriendsChatMember[] memberlist = (FriendsChatMember[])clanMemberManager.getMembers();
            ArrayList<String> keywords = new ArrayList<String>();
            for (FriendsChatMember member : memberlist) {
                if (member.getRank() != FriendsChatRank.UNRANKED || this.queue.doesCustExist(member.getName())) continue;
                keywords.add(member.getName());
            }
            this.basQueuePanel.setAutoCompleteKeyWords(keywords);
        }
        try {
            this.queue.refresh();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        SwingUtilities.invokeLater(() -> this.basQueuePanel.populate(this.queue.getQueue()));
    }

    public void markCustomer(int option, Customer cust) {
        int UNSUPORRTED = 0;
        if (option != UNSUPORRTED) {
            try {
                this.queue.mark(option, cust);
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        this.refreshQueue();
        SwingUtilities.invokeLater(() -> this.basQueuePanel.populate(this.queue.getQueue()));
    }
}

