/*
 * Decompiled with CFR 0.152.
 */
package com.queuehelper;

import com.queuehelper.QueueHelperHTTPClient;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class BASHTTPClient
implements QueueHelperHTTPClient {
    private static BASHTTPClient client;
    private String apikey;
    private static final String HOST_PATH = "vrqgs27251.execute-api.eu-west-2.amazonaws.com";
    private HttpUrl apiBase;
    private OkHttpClient Basclient;
    private String CustIDQuery;
    private String RetrieveCSVQuery;
    private String UPDATE_OPTION_GNC;
    private String UPDATE_OPTION_ATQ;
    private String UPDATE_OPTION_PRI;
    private String UPDATE_OPTION_NAM;
    private String UPDATE_OPTION_FORMI;
    private String UPDATE_OPTION_QN;
    private String csvList;
    private String UPDATE_OPTION_QHN;
    private String UPDATE_OPTION_C;
    private String UPDATE_OPTION_M;
    private String UPDATE_OPTION_R;
    private String OptionQuery;
    private String CustomerNameQuery;
    private String basephp;

    private BASHTTPClient(String apikey, OkHttpClient basclient) throws IOException {
        this.Basclient = basclient;
        this.apikey = apikey;
        this.apiBase = new HttpUrl.Builder().scheme("https").host(HOST_PATH).addPathSegment("Bas_Queuehelper").build();
        String[] pathsArray = this.getFilePaths();
        this.updateFilePaths(pathsArray);
    }

    public static BASHTTPClient getInstance(String apikey, OkHttpClient basclient) throws IOException {
        if (client == null) {
            client = new BASHTTPClient(apikey, basclient);
        } else {
            client.setAPikey(apikey);
        }
        return client;
    }

    @Override
    public void setAPikey(String apikey) {
        this.apikey = apikey;
    }

    public void clearFilePaths() {
        this.RetrieveCSVQuery = "";
        this.UPDATE_OPTION_GNC = "";
        this.UPDATE_OPTION_ATQ = "";
        this.UPDATE_OPTION_PRI = "";
        this.UPDATE_OPTION_NAM = "";
        this.UPDATE_OPTION_FORMI = "";
        this.UPDATE_OPTION_QN = "";
        this.csvList = "";
        this.UPDATE_OPTION_QHN = "";
        this.UPDATE_OPTION_C = "";
        this.UPDATE_OPTION_M = "";
        this.UPDATE_OPTION_R = "";
        this.OptionQuery = "";
        this.CustomerNameQuery = "";
        this.basephp = "";
        this.CustIDQuery = "";
    }

    private void updateFilePaths(String[] paths) {
        this.RetrieveCSVQuery = paths[0];
        this.UPDATE_OPTION_GNC = paths[1];
        this.UPDATE_OPTION_ATQ = paths[2];
        this.UPDATE_OPTION_PRI = paths[3];
        this.UPDATE_OPTION_NAM = paths[4];
        this.UPDATE_OPTION_FORMI = paths[5];
        this.UPDATE_OPTION_QN = paths[6];
        this.csvList = paths[7];
        this.UPDATE_OPTION_QHN = paths[8];
        this.UPDATE_OPTION_C = paths[9];
        this.UPDATE_OPTION_M = paths[10];
        this.UPDATE_OPTION_R = paths[11];
        this.OptionQuery = paths[12];
        this.CustomerNameQuery = paths[13];
        this.basephp = paths[14];
        this.CustIDQuery = paths[15];
    }

    private String[] getFilePaths() throws IOException {
        OkHttpClient client = this.Basclient;
        HttpUrl url = this.apiBase.newBuilder().addPathSegment("grabfilestrings").build();
        Request request = new Request.Builder().header("User-Agent", "RuneLite").url(url).header("Content-Type", "application/json").header("x-api-key", this.apikey).build();
        try (Response response = client.newCall(request).execute();){
            String[] stringArray = response.body().string().split("\"")[3].split(",");
            return stringArray;
        }
    }

    @Override
    public String getCustomerID(String name) throws IOException {
        OkHttpClient client = this.Basclient;
        HttpUrl url = this.apiBase.newBuilder().addPathSegment("bas").addPathSegment(this.basephp).addQueryParameter(this.CustIDQuery, URLEncoder.encode(name.replace('\u00a0', ' '), "UTF-8")).build();
        Request request = new Request.Builder().header("User-Agent", "RuneLite").url(url).header("Content-Type", "application/json").header("x-api-key", this.apikey).build();
        try (Response response = client.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
    }

    @Override
    public boolean markCustomer(int option, String name) throws IOException {
        OkHttpClient client = this.Basclient;
        HttpUrl url = this.apiBase.newBuilder().addPathSegment("bas").addPathSegment(this.basephp).addQueryParameter(this.OptionQuery, "" + option).addQueryParameter(this.CustomerNameQuery, URLEncoder.encode(Text.removeTags((String)Text.sanitize((String)name)).replace('\u00a0', ' '), "UTF-8")).build();
        Request request = new Request.Builder().header("User-Agent", "RuneLite").url(url).header("Content-Type", "application/json").header("x-api-key", this.apikey).build();
        try (Response response = client.newCall(request).execute();){
            boolean bl = response.isSuccessful();
            return bl;
        }
    }

    @Override
    public List<String[]> readCSV(List<String[]> csv) throws IOException {
        int PRIORITY = 2;
        int RNAMES = 4;
        int PNAME = 3;
        int STATUS = 0;
        int ID = 1;
        int ITEM = 5;
        int NOTES = 7;
        OkHttpClient client = this.Basclient;
        HttpUrl url = this.apiBase.newBuilder().addPathSegment("bas").addPathSegment(this.basephp).addQueryParameter(this.RetrieveCSVQuery, "1").build();
        Request request = new Request.Builder().header("User-Agent", "RuneLite").url(url).header("Content-Type", "application/json").header("x-api-key", this.apikey).build();
        try (Response response = client.newCall(request).execute();){
            String[] CSVLines;
            csv.clear();
            for (String line : CSVLines = response.body().string().split("\n")) {
                String[] LineItems = line.split(",");
                if (LineItems[0].equals("Current time:") || LineItems[0].equals("Last edited:") || LineItems[0].equals("Status")) continue;
                csv.add(new String[]{LineItems[PRIORITY], LineItems[PRIORITY].equals("R") ? LineItems[RNAMES] : LineItems[PNAME], LineItems[STATUS], LineItems[ID], LineItems[ITEM], LineItems[NOTES]});
            }
            response.close();
            List<String[]> list = csv;
            return list;
        }
    }

    @Override
    public NavigationButton getNavButton() {
        BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), (String)"/panellogo.png");
        NavigationButton navButton = NavigationButton.builder().tooltip("BAS queue + options").icon(icon).priority(2).build();
        return navButton;
    }

    @Override
    public boolean updateQueuebackend(StringBuilder urlList, String name) throws IOException {
        OkHttpClient client = this.Basclient;
        HttpUrl url = this.apiBase.newBuilder().addPathSegment("bas").addPathSegment(this.basephp).addQueryParameter(this.csvList, urlList.toString()).addQueryParameter(this.UPDATE_OPTION_QHN, URLEncoder.encode(Text.sanitize((String)name), "UTF-8")).build();
        Request request = new Request.Builder().header("User-Agent", "RuneLite").url(url).header("Content-Type", "application/json").header("x-api-key", this.apikey).build();
        try (Response response = client.newCall(request).execute();){
            boolean bl = response.isSuccessful();
            return bl;
        }
    }

    @Override
    public boolean addCustomer(String itemName, String priority, String custName, String addedBy) throws IOException {
        OkHttpClient client = this.Basclient;
        HttpUrl url = this.apiBase.newBuilder().addPathSegment("bas").addPathSegment(this.basephp).addQueryParameter(this.UPDATE_OPTION_ATQ, "1").addQueryParameter(this.UPDATE_OPTION_PRI, priority).addQueryParameter(this.UPDATE_OPTION_NAM, URLEncoder.encode(custName.replace('\u00a0', ' '), "UTF-8")).addQueryParameter(this.UPDATE_OPTION_FORMI, itemName).addQueryParameter(this.UPDATE_OPTION_QN, addedBy).build();
        Request request = new Request.Builder().header("User-Agent", "RuneLite").url(url).header("Content-Type", "application/json").header("x-api-key", this.apikey).build();
        try (Response response = client.newCall(request).execute();){
            boolean bl = response.isSuccessful();
            return bl;
        }
    }

    @Override
    public boolean sendChatMsgDiscord(ChatMessage chatmessage) throws IOException {
        String unhashedMsg = chatmessage.getName() + chatmessage.getMessage() + chatmessage.getTimestamp() / 10 * 10;
        int hasedMsg = unhashedMsg.hashCode();
        OkHttpClient client = this.Basclient;
        HttpUrl url = this.apiBase.newBuilder().addPathSegment("disc").build();
        Request request = new Request.Builder().header("User-Agent", "RuneLite").url(url).header("Content-Type", "application/json").header("x-api-key", this.apikey).header("username", chatmessage.getName().replace('\u00a0', ' ')).header("msg", chatmessage.getMessage()).header("hash", String.valueOf(hasedMsg)).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
        return true;
    }
}

