/*
 * Decompiled with CFR 0.152.
 */
package com.queuehelper;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class AutoComplete
implements DocumentListener {
    private JTextArea textField;
    private List<String> keywords;
    private Mode mode = Mode.INSERT;

    public AutoComplete(JTextArea textField, List<String> keywords) {
        this.textField = textField;
        this.keywords = keywords;
        Collections.sort(keywords);
    }

    public void setKeyWords(List<String> Keywords) {
        this.keywords = Keywords;
        Collections.sort(this.keywords);
    }

    @Override
    public void changedUpdate(DocumentEvent ev) {
    }

    @Override
    public void removeUpdate(DocumentEvent ev) {
    }

    @Override
    public void insertUpdate(DocumentEvent ev) {
        int w;
        if (ev.getLength() != 1) {
            return;
        }
        int pos = ev.getOffset();
        String content = null;
        try {
            content = this.textField.getText(0, pos + 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        for (w = pos; w >= 0 && Character.isLetter(content.charAt(w)); --w) {
        }
        if (pos - w < 2) {
            return;
        }
        String prefix = content.substring(w + 1);
        int n = Collections.binarySearch(this.keywords, prefix);
        if (n < 0 && -n <= this.keywords.size()) {
            String match = this.keywords.get(-n - 1);
            if (match.startsWith(prefix)) {
                String completion = match.substring(pos - w);
                SwingUtilities.invokeLater(new CompletionTask(completion, pos + 1));
            }
        } else {
            this.mode = Mode.INSERT;
        }
    }

    private class CompletionTask
    implements Runnable {
        private String completion;
        private int position;

        CompletionTask(String completion, int position) {
            this.completion = completion;
            this.position = position;
        }

        @Override
        public void run() {
            StringBuffer sb = new StringBuffer(AutoComplete.this.textField.getText());
            sb.insert(this.position, this.completion);
            AutoComplete.this.textField.setText(sb.toString());
            AutoComplete.this.textField.setCaretPosition(this.position + this.completion.length());
            AutoComplete.this.textField.moveCaretPosition(this.position);
            AutoComplete.this.mode = Mode.COMPLETION;
        }
    }

    public class CommitAction
    extends AbstractAction {
        private static final long serialVersionUID = 5794543109646743416L;

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (AutoComplete.this.mode == Mode.COMPLETION) {
                int pos = AutoComplete.this.textField.getSelectionEnd();
                StringBuffer sb = new StringBuffer(AutoComplete.this.textField.getText());
                sb.insert(pos, "");
                AutoComplete.this.textField.setText(sb.toString());
                try {
                    AutoComplete.this.textField.setCaretPosition(pos + 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                AutoComplete.this.mode = Mode.INSERT;
            } else {
                AutoComplete.this.textField.replaceSelection("\t");
            }
        }
    }

    private static enum Mode {
        INSERT,
        COMPLETION;

    }
}

