/*
 * Decompiled with CFR 0.152.
 */
package com.idyl.prophunt;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import com.idyl.prophunt.PropHuntConfig;
import com.idyl.prophunt.PropHuntDataManager;
import com.idyl.prophunt.PropHuntModelId;
import com.idyl.prophunt.PropHuntOverlay;
import com.idyl.prophunt.PropHuntPanel;
import com.idyl.prophunt.PropHuntPlayerData;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Model;
import net.runelite.api.Player;
import net.runelite.api.Renderable;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.SpritePixels;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOpened;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.callback.Hooks;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Prop Hunt")
public class PropHuntPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PropHuntPlugin.class);
    public final String CONFIG_KEY = "prophunt";
    public final Pattern modelEntry = Pattern.compile("[a-zA-Z]+:[ ]?[0-9]+");
    @Inject
    private Client client;
    @Inject
    private PropHuntConfig config;
    @Inject
    private Hooks hooks;
    @Inject
    private ClientThread clientThread;
    @Inject
    private PropHuntDataManager propHuntDataManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PropHuntOverlay propHuntOverlay;
    @Inject
    private ClientToolbar clientToolbar;
    private PropHuntPanel panel;
    private NavigationButton navButton;
    private RuneLiteObject localDisguise;
    private HashMap<String, RuneLiteObject> playerDisguises = new HashMap();
    private String[] players;
    private HashMap<String, PropHuntPlayerData> playersData;
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;
    private final long SECONDS_BETWEEN_GET = 5L;
    private static final int DOT_PLAYER = 2;
    private static final int DOT_FRIEND = 3;
    private static final int DOT_TEAM = 4;
    private static final int DOT_FRIENDSCHAT = 5;
    private static final int DOT_CLAN = 6;
    private SpritePixels[] originalDotSprites;
    private int rightClickCounter = 0;

    protected void startUp() throws Exception {
        this.playersData = new HashMap();
        this.hooks.registerRenderableDrawListener(this.drawListener);
        this.clientThread.invokeLater(() -> this.transmogPlayer(this.client.getLocalPlayer()));
        this.setPlayersFromString(this.config.players());
        this.getPlayerConfigs();
        this.storeOriginalDots();
        this.hideMinimapDots();
        this.panel = new PropHuntPanel(this);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"panel_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Prop Hunt").priority(5).icon(icon).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.updateDropdown();
        this.overlayManager.add((Overlay)this.propHuntOverlay);
    }

    protected void shutDown() throws Exception {
        this.clientThread.invokeLater(this::removeAllTransmogs);
        this.overlayManager.remove((Overlay)this.propHuntOverlay);
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
        this.clientToolbar.removeNavigation(this.navButton);
        this.restoreOriginalDots();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (GameState.LOGGED_IN.equals((Object)event.getGameState())) {
            if (this.config.hideMode()) {
                this.clientThread.invokeLater(() -> this.transmogPlayer(this.client.getLocalPlayer()));
            }
            if (this.client.getLocalPlayer().getName() != null) {
                this.propHuntDataManager.updatePropHuntApi(new PropHuntPlayerData(this.client.getLocalPlayer().getName(), this.config.hideMode(), this.getModelID(), this.config.orientation()));
            }
        }
        if (event.getGameState() == GameState.LOGIN_SCREEN && this.originalDotSprites == null) {
            this.storeOriginalDots();
            if (this.config.hideMinimapDots()) {
                this.hideMinimapDots();
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.clientThread.invokeLater(this::removeAllTransmogs);
        if (this.config.hideMode()) {
            this.clientThread.invokeLater(() -> this.transmogPlayer(this.client.getLocalPlayer()));
        }
        if (event.getKey().equals("players")) {
            this.setPlayersFromString(this.config.players());
            this.clientThread.invokeLater(() -> this.removeTransmogs());
            this.getPlayerConfigs();
        }
        if (event.getKey().equals("hideMinimapDots")) {
            if (this.config.hideMinimapDots()) {
                this.hideMinimapDots();
            } else {
                this.restoreOriginalDots();
            }
        }
        if (event.getKey().equals("models")) {
            this.updateDropdown();
        }
        if (this.client.getLocalPlayer() != null) {
            this.propHuntDataManager.updatePropHuntApi(new PropHuntPlayerData(this.client.getLocalPlayer().getName(), this.config.hideMode(), this.getModelID(), this.config.orientation()));
            this.clientThread.invokeLater(() -> this.transmogOtherPlayers());
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (this.config.hideMode() && this.localDisguise != null) {
            LocalPoint playerPoint = this.client.getLocalPlayer().getLocalLocation();
            this.localDisguise.setLocation(playerPoint, this.client.getPlane());
        }
        this.client.getPlayers().forEach(player -> this.updateDisguiseLocation((Player)player));
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (this.config.limitRightClicks() && !this.config.hideMode()) {
            if (this.rightClickCounter >= this.config.maxRightClicks()) {
                this.sendHighlightedChatMessage("You have used all of your right clicks!");
                return;
            }
            ++this.rightClickCounter;
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (this.playerDisguises == null || this.playerDisguises.size() == 0) {
            return;
        }
        if (!event.getOption().startsWith("Walk here")) {
            if (this.config.depriorizteMenuOptions()) {
                event.getMenuEntry().setDeprioritized(true);
            }
            return;
        }
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked event) {
        if (event.getEntry() == PropHuntOverlay.RESET_ENTRY) {
            this.rightClickCounter = 0;
        }
    }

    private void findPlayer(String player) {
        this.sendNormalChatMessage("You found " + player + "!");
    }

    private void sendNormalChatMessage(String message) {
        ChatMessageBuilder msg = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(message);
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.ITEM_EXAMINE).runeLiteFormattedMessage(msg.build()).build());
    }

    private void sendHighlightedChatMessage(String message) {
        ChatMessageBuilder msg = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(message);
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(msg.build()).build());
    }

    @VisibleForTesting
    boolean shouldDraw(Renderable renderable, boolean drawingUI) {
        if (renderable instanceof Player) {
            Player player = (Player)renderable;
            Player local = this.client.getLocalPlayer();
            if (player == local) {
                return !this.config.hideMode();
            }
            if (this.players == null) {
                return true;
            }
            ArrayList<String> playerList = new ArrayList<String>(Arrays.asList(this.players));
            if (playerList.contains(player.getName())) {
                PropHuntPlayerData data = this.playersData.get(player.getName());
                if (data == null) {
                    return true;
                }
                if (data.hiding) {
                    return !data.hiding;
                }
            }
        }
        return true;
    }

    private void transmogPlayer(Player player) {
        this.transmogPlayer(player, this.getModelID(), this.config.orientation(), true);
    }

    private void transmogPlayer(Player player, int modelId, int orientation, boolean local) {
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        int modelID = modelId;
        RuneLiteObject disguise = this.client.createRuneLiteObject();
        LocalPoint loc = LocalPoint.fromWorld((Client)this.client, (WorldPoint)player.getWorldLocation());
        if (loc == null) {
            return;
        }
        Model model = this.client.loadModel(modelID);
        if (model == null) {
            Instant loadTimeOutInstant = Instant.now().plus(Duration.ofSeconds(5L));
            this.clientThread.invoke(() -> {
                if (Instant.now().isAfter(loadTimeOutInstant)) {
                    return true;
                }
                Model reloadedModel = this.client.loadModel(modelID);
                if (reloadedModel == null) {
                    return false;
                }
                this.localDisguise.setModel(reloadedModel);
                return true;
            });
        } else {
            disguise.setModel(model);
        }
        disguise.setLocation(player.getLocalLocation(), player.getWorldLocation().getPlane());
        disguise.setActive(true);
        disguise.setOrientation(orientation);
        if (local) {
            this.localDisguise = disguise;
        } else {
            this.playerDisguises.put(player.getName(), disguise);
        }
    }

    private void transmogOtherPlayers() {
        if (this.players == null || this.client.getLocalPlayer() == null) {
            return;
        }
        this.client.getPlayers().forEach(player -> {
            if (this.client.getLocalPlayer() == player) {
                return;
            }
            PropHuntPlayerData data = this.playersData.get(player.getName());
            if (data == null || !data.hiding) {
                return;
            }
            this.transmogPlayer((Player)player, data.modelID, data.orientation, false);
        });
    }

    private void removeLocalTransmog() {
        if (this.localDisguise != null) {
            this.localDisguise.setActive(false);
        }
        this.localDisguise = null;
    }

    private void removeTransmogs() {
        this.playerDisguises.forEach((p, disguise) -> {
            if (disguise == null) {
                return;
            }
            disguise.setActive(false);
        });
    }

    private void removeAllTransmogs() {
        this.removeTransmogs();
        this.removeLocalTransmog();
    }

    private void updateDisguiseLocation(Player p) {
        RuneLiteObject obj = this.playerDisguises.get(p.getName());
        if (obj == null) {
            return;
        }
        obj.setLocation(p.getLocalLocation(), p.getWorldLocation().getPlane());
    }

    private void setPlayersFromString(String playersString) {
        String[] p = playersString.split(",");
        for (int i = 0; i < p.length; ++i) {
            p[i] = p[i].trim();
        }
        this.players = p;
    }

    @Schedule(period=5L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void getPlayerConfigs() {
        if (this.players.length < 1 || this.config.players().isEmpty()) {
            return;
        }
        this.propHuntDataManager.getPropHuntersByUsernames(this.players);
    }

    public void updatePlayerData(HashMap<String, PropHuntPlayerData> data) {
        this.clientThread.invokeLater(() -> {
            this.removeTransmogs();
            this.playersData.clear();
            this.playerDisguises.clear();
            this.playersData.putAll(data);
            this.playersData.values().forEach(player -> this.playerDisguises.put(player.username, null));
            this.transmogOtherPlayers();
        });
    }

    private void hideMinimapDots() {
        SpritePixels[] mapDots = this.client.getMapDots();
        if (mapDots == null) {
            return;
        }
        mapDots[2] = this.client.createSpritePixels(new int[0], 0, 0);
        mapDots[6] = this.client.createSpritePixels(new int[0], 0, 0);
        mapDots[3] = this.client.createSpritePixels(new int[0], 0, 0);
        mapDots[5] = this.client.createSpritePixels(new int[0], 0, 0);
        mapDots[4] = this.client.createSpritePixels(new int[0], 0, 0);
    }

    private void storeOriginalDots() {
        SpritePixels[] originalDots = this.client.getMapDots();
        if (originalDots == null) {
            return;
        }
        this.originalDotSprites = Arrays.copyOf(originalDots, originalDots.length);
    }

    private void restoreOriginalDots() {
        SpritePixels[] mapDots = this.client.getMapDots();
        if (this.originalDotSprites == null || mapDots == null) {
            return;
        }
        System.arraycopy(this.originalDotSprites, 0, mapDots, 0, mapDots.length);
    }

    private int getModelID() {
        return this.config.modelID();
    }

    public void setRandomModelID() {
        this.configManager.setConfiguration("prophunt", "modelID", (Object)ThreadLocalRandom.current().nextInt(this.config.randMinID(), this.config.randMaxID() + 1));
    }

    private void updateDropdown() {
        String[] modelList = this.config.models().split(",");
        PropHuntModelId.map.clear();
        for (String model : modelList) {
            if (!this.modelEntry.matcher(model = model.trim()).matches()) continue;
            String modelName = model.split(":")[0].trim();
            String modelId = model.split(":")[1].trim();
            PropHuntModelId.add(modelName, Integer.parseInt(modelId));
        }
        this.panel.updateComboBox();
    }

    public void setModelID(PropHuntModelId modelData) {
        this.configManager.setConfiguration("prophunt", "modelID", (Object)modelData.getId());
    }

    public void rotateModel(int dir) {
        if (this.localDisguise != null) {
            int orientation = this.config.orientation() + 500 * dir;
            orientation = (orientation % 2000 + 2000) % 2000;
            this.localDisguise.setOrientation(orientation);
            this.configManager.setConfiguration("prophunt", "orientation", (Object)orientation);
        }
    }

    @Provides
    PropHuntConfig provideConfig(ConfigManager configManager) {
        return (PropHuntConfig)configManager.getConfig(PropHuntConfig.class);
    }

    public int getRightClickCounter() {
        return this.rightClickCounter;
    }
}

