/*
 * Decompiled with CFR 0.152.
 */
package com.idyl.prophunt;

import com.idyl.prophunt.PropHuntModelId;
import com.idyl.prophunt.PropHuntPlugin;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;

public class PropHuntPanel
extends PluginPanel
implements ActionListener {
    private PropHuntPlugin plugin;
    private JButton myButton;
    private JComboBox<String> comboBox;
    private JLabel title;

    public PropHuntPanel(final PropHuntPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 0, 10, 0);
        this.title = new JLabel("Prop Hunt");
        this.title.setFont(FontManager.getRunescapeBoldFont());
        this.title.setHorizontalAlignment(0);
        this.add(this.title, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 0, 5, 0);
        JLabel label2 = new JLabel("Custom Model List:");
        this.add(label2, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 0, 5, 0);
        this.comboBox = new JComboBox();
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedOption = (String)PropHuntPanel.this.comboBox.getSelectedItem();
                if (PropHuntModelId.map.get(selectedOption) == null) {
                    return;
                }
                plugin.setModelID(PropHuntModelId.valueOf(selectedOption));
            }
        });
        this.updateComboBox();
        this.add(this.comboBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 0, 5, 3);
        this.myButton = new JButton("Randomize Model");
        this.myButton.addActionListener(this);
        this.add(this.myButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 0, 5, 3);
        JButton rotateClockwiseButton = new JButton("\u21bb");
        rotateClockwiseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.rotateModel(1);
            }
        });
        this.add(rotateClockwiseButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 3, 5, 0);
        JButton rotateCounterButton = new JButton("\u21ba");
        rotateCounterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.rotateModel(-1);
            }
        });
        this.add(rotateCounterButton, gbc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.plugin.setRandomModelID();
    }

    public void updateComboBox() {
        this.comboBox.removeAllItems();
        PropHuntModelId.map.keySet().forEach(item -> this.comboBox.addItem((String)item));
    }
}

