/*
 * Decompiled with CFR 0.152.
 */
package com.idyl.prophunt;

import com.idyl.prophunt.PropHuntConfig;
import com.idyl.prophunt.PropHuntPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class PropHuntOverlay
extends OverlayPanel {
    public static OverlayMenuEntry RESET_ENTRY = new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, "Reset", "Counter");
    private PropHuntPlugin plugin;
    private PropHuntConfig config;
    private final LineComponent rightClicksRemainingComponent;

    @Inject
    private PropHuntOverlay(PropHuntPlugin plugin, PropHuntConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.getMenuEntries().add(RESET_ENTRY);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.HIGH);
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.rightClicksRemainingComponent = LineComponent.builder().left("Right Clicks Remaining:").right("").build();
        this.panelComponent.getChildren().add(this.rightClicksRemainingComponent);
        this.setClearChildren(false);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.limitRightClicks()) {
            return null;
        }
        graphics.setFont(FontManager.getRunescapeFont());
        this.rightClicksRemainingComponent.setRightColor(this.getColor());
        this.rightClicksRemainingComponent.setRight("" + this.getClicksRemaining());
        return super.render(graphics);
    }

    private Color getColor() {
        return this.getClicksRemaining() > 3 ? Color.GREEN : (this.getClicksRemaining() > 0 ? Color.YELLOW : Color.RED);
    }

    private int getClicksRemaining() {
        return this.config.maxRightClicks() - this.plugin.getRightClickCounter();
    }
}

