/*
 * Decompiled with CFR 0.152.
 */
package com.idyl.prophunt;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.idyl.prophunt.PropHuntPlayerData;
import com.idyl.prophunt.PropHuntPlugin;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PropHuntDataManager {
    private static final Logger log = LoggerFactory.getLogger(PropHuntDataManager.class);
    private final String baseUrl = "http://props.idyl.live:8080";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    @Inject
    private PropHuntPlugin plugin;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;

    protected void updatePropHuntApi(PropHuntPlayerData data) {
        String username = this.urlifyString(data.username);
        String url = "http://props.idyl.live:8080".concat("/prop-hunters/" + username);
        try {
            Request r = new Request.Builder().url(url).post(RequestBody.create((MediaType)JSON, (String)this.gson.toJson((Object)data))).build();
            this.okHttpClient.newCall(r).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    log.debug("Error sending post data", (Throwable)e);
                }

                public void onResponse(Call call, Response response) {
                    if (response.isSuccessful()) {
                        log.debug("Successfully sent prop hunt data");
                        response.close();
                    } else {
                        log.debug("Post request unsuccessful");
                        response.close();
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            log.error("Bad URL given: " + e.getLocalizedMessage());
        }
    }

    public void getPropHuntersByUsernames(String[] players) {
        String playersString = this.urlifyString(String.join((CharSequence)",", players));
        try {
            Request r = new Request.Builder().url("http://props.idyl.live:8080".concat("/prop-hunters/".concat(playersString))).get().build();
            this.okHttpClient.newCall(r).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    log.info("Error getting prop hunt data by username", (Throwable)e);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    if (response.isSuccessful()) {
                        try {
                            JsonArray j = (JsonArray)PropHuntDataManager.this.gson.fromJson(response.body().string(), JsonArray.class);
                            HashMap<String, PropHuntPlayerData> playerData = PropHuntDataManager.this.parsePropHuntData(j);
                            PropHuntDataManager.this.plugin.updatePlayerData(playerData);
                        }
                        catch (JsonSyntaxException | IOException e) {
                            log.error(e.getMessage());
                        }
                    }
                    response.close();
                }
            });
        }
        catch (IllegalArgumentException e) {
            log.error("Bad URL given: " + e.getLocalizedMessage());
        }
    }

    private HashMap<String, PropHuntPlayerData> parsePropHuntData(JsonArray j) {
        HashMap<String, PropHuntPlayerData> l = new HashMap<String, PropHuntPlayerData>();
        for (JsonElement jsonElement : j) {
            JsonObject jObj = jsonElement.getAsJsonObject();
            String username = jObj.get("username").getAsString();
            PropHuntPlayerData d = new PropHuntPlayerData(jObj.get("username").getAsString(), jObj.get("hiding").getAsBoolean(), jObj.get("modelID").getAsInt(), jObj.get("orientation").getAsInt());
            l.put(username, d);
        }
        return l;
    }

    private String urlifyString(String str) {
        return str.trim().replaceAll("\\s", "%20");
    }
}

