/*
 * Decompiled with CFR 0.152.
 */
package com.asthereon.green_thumb;

import com.asthereon.green_thumb.GreenThumbConfig;
import com.asthereon.green_thumb.Seed;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import org.apache.commons.lang3.StringUtils;

public class GreenThumbOverlay
extends Overlay {
    private static final int INVENTORY_ITEM_WIDGETID = WidgetInfo.INVENTORY.getPackedId();
    private static final int BANK_ITEM_WIDGETID = WidgetInfo.BANK_ITEM_CONTAINER.getPackedId();
    private static final int BANKED_INVENTORY_ITEM_WIDGETID = WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER.getPackedId();
    private static final int SEED_VAULT_WIDGETID = WidgetInfo.SEED_VAULT_ITEM_CONTAINER.getPackedId();
    private static final int SEED_VAULT_INVENTORY_WIDGETID = WidgetInfo.SEED_VAULT_INVENTORY_ITEMS_CONTAINER.getPackedId();
    private static final int GROUP_STORAGE_ITEM_WIDGETID = WidgetInfo.GROUP_STORAGE_ITEM_CONTAINER.getPackedId();
    private final Client client;
    private final TooltipManager tooltipManager;
    private final ItemManager itemManager;
    private final GreenThumbConfig config;
    private final StringBuilder stringBuilder = new StringBuilder();

    @Inject
    GreenThumbOverlay(Client client, TooltipManager tooltipManager, ItemManager itemManager, GreenThumbConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.client = client;
        this.tooltipManager = tooltipManager;
        this.itemManager = itemManager;
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Dimension render(Graphics2D graphics) {
        if (this.client.isMenuOpen()) {
            return null;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int last = menuEntries.length - 1;
        if (last < 0) {
            return null;
        }
        MenuEntry menuEntry = menuEntries[last];
        if (StringUtils.isEmpty((CharSequence)menuEntry.getTarget()) || menuEntry.getOption().contains("View") || menuEntry.getParam0() < 0) {
            return null;
        }
        MenuAction action = menuEntry.getType();
        int widgetId = menuEntry.getParam1();
        int groupId = WidgetInfo.TO_GROUP((int)widgetId);
        switch (action) {
            case WIDGET_USE_ON_ITEM: 
            case WIDGET_TARGET: 
            case CC_OP: 
            case ITEM_USE: 
            case ITEM_FIRST_OPTION: 
            case ITEM_SECOND_OPTION: 
            case ITEM_THIRD_OPTION: 
            case ITEM_FOURTH_OPTION: 
            case ITEM_FIFTH_OPTION: {
                switch (groupId) {
                    case 12: 
                    case 15: 
                    case 149: 
                    case 630: 
                    case 631: 
                    case 724: {
                        String itemName;
                        Seed seed;
                        Optional<ItemContainer> container = this.getContainer(widgetId);
                        if (!container.isPresent()) return null;
                        Optional<Item> item = this.getContainerItem(container.get(), menuEntry.getParam0());
                        if (item.isPresent() && (seed = Seed.getSeedFromItemName(itemName = this.stripExtra(this.itemManager.getItemComposition(item.get().getId()).getName()))) != null) {
                            this.stringBuilder.append(seed.getTooltip(this.config, this.client, item.get().getQuantity()));
                        }
                        if (this.stringBuilder.length() <= 0) return null;
                        this.addTooltip();
                        return null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    private Optional<ItemContainer> getContainer(int widgetId) {
        if (widgetId == INVENTORY_ITEM_WIDGETID || widgetId == BANKED_INVENTORY_ITEM_WIDGETID || widgetId == SEED_VAULT_INVENTORY_WIDGETID) {
            return Optional.ofNullable(this.client.getItemContainer(InventoryID.INVENTORY));
        }
        if (widgetId == BANK_ITEM_WIDGETID) {
            return Optional.ofNullable(this.client.getItemContainer(InventoryID.BANK));
        }
        if (widgetId == SEED_VAULT_WIDGETID) {
            return Optional.ofNullable(this.client.getItemContainer(InventoryID.SEED_VAULT));
        }
        if (widgetId == GROUP_STORAGE_ITEM_WIDGETID) {
            return Optional.ofNullable(this.client.getItemContainer(InventoryID.GROUP_STORAGE));
        }
        return Optional.empty();
    }

    private Optional<Item> getContainerItem(ItemContainer container, int itemId) {
        return Optional.ofNullable(container.getItem(itemId));
    }

    private void addTooltip() {
        this.tooltipManager.add(new Tooltip(this.stringBuilder.toString()));
        this.stringBuilder.setLength(0);
    }

    private String stripExtra(String item) {
        String stripped = item.replaceAll("\\s?\\(\\d\\)", "");
        return stripped.substring(0, 1).toUpperCase() + stripped.substring(1);
    }
}

