/*
 * Decompiled with CFR 0.152.
 */
package com.brastasauce.purchaseprogress.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.util.QuantityFormatter;

public class PurchaseProgressTotalPanel
extends JPanel {
    private float percent;
    private final Color background;

    PurchaseProgressTotalPanel(long value, long totalCost, Color background) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 0));
        this.background = background;
        JPanel totalPanel = new JPanel(new BorderLayout());
        totalPanel.setBackground(new Color(0, 0, 0, 0));
        totalPanel.setOpaque(false);
        JLabel totalLabel = new JLabel();
        totalLabel.setForeground(new Color(255, 202, 36));
        totalLabel.setText("Total: " + QuantityFormatter.formatNumber((long)totalCost) + " gp");
        totalPanel.add((Component)totalLabel, "West");
        JLabel percentLabel = new JLabel();
        percentLabel.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.percent = (float)value / (float)totalCost * 100.0f;
        if (this.percent >= 100.0f) {
            this.percent = 100.0f;
        }
        percentLabel.setText(String.format("%.0f", Float.valueOf(this.percent)) + "%");
        totalPanel.add((Component)percentLabel, "East");
        this.add((Component)totalPanel, "Center");
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(new Color(12, 85, 35));
        int greenWidth = (int)((float)this.getWidth() * this.percent / 100.0f);
        g.fillRect(0, 0, greenWidth, this.getHeight());
        if (greenWidth != this.getWidth()) {
            g.setColor(this.background);
            g.fillRect(greenWidth, 0, this.getWidth() - greenWidth, this.getHeight());
        }
    }
}

