/*
 * Decompiled with CFR 0.152.
 */
package com.brastasauce.purchaseprogress.ui;

import com.brastasauce.purchaseprogress.PurchaseProgressPlugin;
import com.brastasauce.purchaseprogress.data.PurchaseProgressGroup;
import com.brastasauce.purchaseprogress.data.PurchaseProgressItem;
import com.brastasauce.purchaseprogress.ui.PurchaseProgressGroupPanel;
import com.brastasauce.purchaseprogress.ui.PurchaseProgressItemPanel;
import com.brastasauce.purchaseprogress.ui.PurchaseProgressResultPanel;
import com.brastasauce.purchaseprogress.ui.PurchaseProgressTotalPanel;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.http.api.item.ItemPrice;

public class PurchaseProgressPluginPanel
extends PluginPanel {
    private static final String PROGRESS_PANEL = "PROGRESS_PANEL";
    private static final String SEARCH_PANEL = "SEARCH_PANEL";
    private static final String RESULTS_PANEL = "RESULTS_PANEL";
    private static final String ERROR_PANEL = "ERROR_PANEL";
    private static final String CONTAINS_ITEM_TITLE = "Info";
    private static final String CONTAINS_ITEM_MESSAGE = "This item is already being tracked.";
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private static final ImageIcon ADD_GROUP_ICON;
    private static final ImageIcon ADD_GROUP_HOVER_ICON;
    private static final ImageIcon CANCEL_ICON;
    private static final ImageIcon CANCEL_HOVER_ICON;
    private static final ImageIcon SORT_ICON;
    private static final ImageIcon SORT_HOVER_ICON;
    private static final int MAX_SEARCH_ITEMS = 100;
    private final PurchaseProgressPlugin plugin;
    private final ClientThread clientThread;
    private final ItemManager itemManager;
    private final RuneLiteConfig runeLiteConfig;
    private final CardLayout centerCard = new CardLayout();
    private final CardLayout searchCard = new CardLayout();
    private final JPanel titlePanel = new JPanel(new BorderLayout());
    private final JLabel title = new JLabel();
    private final JPanel progressActions = new JPanel(new BorderLayout());
    private final JLabel addItem = new JLabel(ADD_ICON);
    private final JLabel addGroup = new JLabel(ADD_GROUP_ICON);
    private final JLabel cancelItem = new JLabel(CANCEL_ICON);
    private final JPanel centerPanel = new JPanel(this.centerCard);
    private final JPanel progressPanel = new JPanel(new BorderLayout());
    private final JPanel valuePanel = new JPanel(new BorderLayout());
    private final JLabel value = new JLabel();
    private final JLabel sortButton = new JLabel();
    private final JPanel progressItemsPanel = new JPanel();
    private final JPanel searchPanel = new JPanel(new BorderLayout());
    private final JPanel searchCenterPanel = new JPanel(this.searchCard);
    private final JPanel searchResultsPanel = new JPanel();
    private final IconTextField searchBar = new IconTextField();
    private final PluginErrorPanel searchErrorPanel = new PluginErrorPanel();
    private final GridBagConstraints constraints = new GridBagConstraints();
    private final List<PurchaseProgressItem> searchItems = new ArrayList<PurchaseProgressItem>();

    @Inject
    PurchaseProgressPluginPanel(final PurchaseProgressPlugin plugin, ClientThread clientThread, ItemManager itemManager, RuneLiteConfig runeLiteConfig) {
        super(false);
        this.plugin = plugin;
        this.clientThread = clientThread;
        this.itemManager = itemManager;
        this.runeLiteConfig = runeLiteConfig;
        this.setLayout(new BorderLayout());
        JPanel container = new JPanel(new BorderLayout());
        container.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.title.setText("Purchase Progress");
        this.title.setForeground(Color.WHITE);
        this.title.setBorder(new EmptyBorder(0, 0, 10, 40));
        JPanel actions = new JPanel(new FlowLayout(0, 8, 3));
        this.addGroup.setToolTipText("Add a group");
        this.addGroup.setBorder(new EmptyBorder(0, 0, 0, 10));
        this.addGroup.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                plugin.addGroup();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PurchaseProgressPluginPanel.this.addGroup.setIcon(ADD_GROUP_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PurchaseProgressPluginPanel.this.addGroup.setIcon(ADD_GROUP_ICON);
            }
        });
        this.progressActions.add((Component)this.addGroup, "West");
        this.addItem.setToolTipText("Add an item from the Grand Exchange");
        this.addItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PurchaseProgressPluginPanel.this.switchToSearch();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PurchaseProgressPluginPanel.this.addItem.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PurchaseProgressPluginPanel.this.addItem.setIcon(ADD_ICON);
            }
        });
        this.progressActions.add((Component)this.addItem, "East");
        actions.add(this.progressActions);
        this.cancelItem.setToolTipText("Cancel");
        this.cancelItem.setVisible(false);
        this.cancelItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PurchaseProgressPluginPanel.this.switchToProgress();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PurchaseProgressPluginPanel.this.cancelItem.setIcon(CANCEL_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PurchaseProgressPluginPanel.this.cancelItem.setIcon(CANCEL_ICON);
            }
        });
        actions.add(this.cancelItem);
        this.titlePanel.add((Component)this.title, "West");
        this.titlePanel.add((Component)actions, "East");
        this.value.setForeground(new Color(255, 202, 36));
        this.value.setBorder(new EmptyBorder(0, 0, 5, 0));
        final JPopupMenu sortPopup = new JPopupMenu();
        JMenuItem sortAscending = new JMenuItem(new AbstractAction("Sort by Price (Low -> High)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.sort(true);
            }
        });
        sortPopup.add(sortAscending);
        JMenuItem sortDescending = new JMenuItem(new AbstractAction("Sort by Price (High -> Low)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.sort(false);
            }
        });
        sortPopup.add(sortDescending);
        this.sortButton.setIcon(SORT_ICON);
        this.sortButton.setBorder(new EmptyBorder(0, 0, 0, 2));
        this.sortButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                sortPopup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PurchaseProgressPluginPanel.this.sortButton.setIcon(SORT_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PurchaseProgressPluginPanel.this.sortButton.setIcon(SORT_ICON);
            }
        });
        this.valuePanel.add((Component)this.value, "West");
        this.valuePanel.add((Component)this.sortButton, "East");
        this.progressItemsPanel.setLayout(new GridBagLayout());
        JPanel pWrapper = new JPanel(new BorderLayout());
        pWrapper.add((Component)this.progressItemsPanel, "North");
        JScrollPane progressWrapper = new JScrollPane(pWrapper);
        progressWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        progressWrapper.setBorder(new EmptyBorder(5, 0, 0, 0));
        progressWrapper.getVerticalScrollBar().setPreferredSize(new Dimension(12, 0));
        progressWrapper.getVerticalScrollBar().setBorder(new EmptyBorder(5, 5, 0, 0));
        this.progressPanel.add((Component)this.valuePanel, "North");
        this.progressPanel.add((Component)progressWrapper, "Center");
        this.searchResultsPanel.setLayout(new GridBagLayout());
        JPanel sWrapper = new JPanel(new BorderLayout());
        sWrapper.add((Component)this.searchResultsPanel, "North");
        JScrollPane resultsWrapper = new JScrollPane(sWrapper);
        resultsWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        resultsWrapper.setBorder(new EmptyBorder(5, 0, 0, 0));
        resultsWrapper.getVerticalScrollBar().setPreferredSize(new Dimension(12, 0));
        resultsWrapper.getVerticalScrollBar().setBorder(new EmptyBorder(5, 5, 0, 0));
        this.constraints.fill = 2;
        this.constraints.gridwidth = 1;
        this.constraints.weightx = 1.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.searchErrorPanel.setContent("Grand Exchange Search", "Search for an item to select");
        JPanel errorWrapper = new JPanel(new BorderLayout());
        errorWrapper.add((Component)this.searchErrorPanel, "North");
        this.searchCenterPanel.add((Component)resultsWrapper, RESULTS_PANEL);
        this.searchCenterPanel.add((Component)errorWrapper, ERROR_PANEL);
        this.searchCard.show(this.searchCenterPanel, ERROR_PANEL);
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(210, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.addClearListener(this::searchForItems);
        this.searchBar.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PurchaseProgressPluginPanel.this.searchForItems();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.searchPanel.add((Component)this.searchBar, "North");
        this.searchPanel.add((Component)this.searchCenterPanel, "Center");
        this.centerPanel.add((Component)this.progressPanel, PROGRESS_PANEL);
        this.centerPanel.add((Component)this.searchPanel, SEARCH_PANEL);
        this.centerCard.show(this.centerPanel, PROGRESS_PANEL);
        container.add((Component)this.titlePanel, "North");
        container.add((Component)this.centerPanel, "Center");
        this.add(container, "Center");
    }

    private void searchForItems() {
        this.searchResultsPanel.removeAll();
        if (this.searchBar.getText().isEmpty()) {
            this.searchResultsPanel.removeAll();
            SwingUtilities.invokeLater(() -> this.searchResultsPanel.updateUI());
            return;
        }
        List results = this.itemManager.search(this.searchBar.getText());
        if (results.isEmpty()) {
            this.searchErrorPanel.setContent("No results found", "No items were found with that name, please try again");
            this.searchCard.show(this.searchCenterPanel, ERROR_PANEL);
            return;
        }
        this.clientThread.invokeLater(() -> this.processResults(results));
    }

    private void processResults(List<ItemPrice> results) {
        this.searchItems.clear();
        this.searchCard.show(this.searchCenterPanel, RESULTS_PANEL);
        int count = 0;
        boolean useActivelyTradedPrice = this.runeLiteConfig.useWikiItemPrices();
        for (ItemPrice item : results) {
            if (count++ > 100) break;
            int itemId = item.getId();
            AsyncBufferedImage itemImage = this.itemManager.getImage(itemId);
            int itemPrice = useActivelyTradedPrice ? this.itemManager.getWikiPrice(item) : item.getPrice();
            this.searchItems.add(new PurchaseProgressItem(itemImage, item.getName(), itemId, itemPrice));
        }
        SwingUtilities.invokeLater(() -> {
            int index = 0;
            for (PurchaseProgressItem item : this.searchItems) {
                PurchaseProgressResultPanel panel = new PurchaseProgressResultPanel(this.plugin, item);
                if (index++ > 0) {
                    this.searchResultsPanel.add((Component)this.createMarginWrapper(panel), this.constraints);
                } else {
                    this.searchResultsPanel.add((Component)panel, this.constraints);
                }
                ++this.constraints.gridy;
            }
            this.validate();
        });
    }

    public void updateProgressPanels() {
        JPanel panel;
        this.progressItemsPanel.removeAll();
        this.updateValue();
        ++this.constraints.gridy;
        int index = 0;
        long totalCost = 0L;
        for (PurchaseProgressGroup group : this.plugin.getGroups()) {
            panel = new PurchaseProgressGroupPanel(this.plugin, this, group);
            if (index++ > 0) {
                this.progressItemsPanel.add((Component)this.createMarginWrapper(panel), this.constraints);
            } else {
                this.progressItemsPanel.add((Component)panel, this.constraints);
            }
            totalCost += ((PurchaseProgressGroupPanel)panel).getTotalCost();
            ++this.constraints.gridy;
        }
        for (PurchaseProgressItem item : this.plugin.getItems()) {
            panel = new PurchaseProgressItemPanel(this.plugin, item);
            if (index++ > 0) {
                this.progressItemsPanel.add((Component)this.createMarginWrapper(panel), this.constraints);
            } else {
                this.progressItemsPanel.add((Component)panel, this.constraints);
            }
            totalCost += (long)item.getGePrice();
            ++this.constraints.gridy;
        }
        if (totalCost != 0L) {
            PurchaseProgressTotalPanel totalCostPanel = new PurchaseProgressTotalPanel(this.plugin.getValue(), totalCost, ColorScheme.DARKER_GRAY_COLOR);
            this.progressItemsPanel.add((Component)this.createMarginWrapper(totalCostPanel), this.constraints);
        }
        this.validate();
    }

    private void updateValue() {
        long progressValue = this.plugin.getValue();
        if (progressValue == 0L) {
            this.value.setText("Visit a bank to calculate value");
        } else {
            this.value.setText("Value: " + QuantityFormatter.formatNumber((long)this.plugin.getValue()) + " gp");
        }
        this.sortButton.setVisible(!this.plugin.getItems().isEmpty());
    }

    public void containsItemWarning() {
        JOptionPane.showConfirmDialog((Component)((Object)this), CONTAINS_ITEM_MESSAGE, CONTAINS_ITEM_TITLE, -1);
    }

    public void switchToProgress() {
        this.cancelItem.setVisible(false);
        this.progressActions.setVisible(true);
        this.centerCard.show(this.centerPanel, PROGRESS_PANEL);
    }

    private void switchToSearch() {
        this.progressActions.setVisible(false);
        this.cancelItem.setVisible(true);
        this.centerCard.show(this.centerPanel, SEARCH_PANEL);
    }

    private JPanel createMarginWrapper(JPanel panel) {
        JPanel marginWrapper = new JPanel(new BorderLayout());
        marginWrapper.setBorder(new EmptyBorder(5, 0, 0, 0));
        marginWrapper.add((Component)panel, "North");
        return marginWrapper;
    }

    static {
        BufferedImage addImage = ImageUtil.loadImageResource(PurchaseProgressPluginPanel.class, (String)"/add_icon.png");
        ADD_ICON = new ImageIcon(addImage);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addImage, (float)0.53f));
        BufferedImage addGroupImage = ImageUtil.loadImageResource(PurchaseProgressGroupPanel.class, (String)"/add_group_icon.png");
        ADD_GROUP_ICON = new ImageIcon(addGroupImage);
        ADD_GROUP_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addGroupImage, (float)0.53f));
        BufferedImage cancelImage = ImageUtil.loadImageResource(PurchaseProgressPluginPanel.class, (String)"/cancel_icon.png");
        CANCEL_ICON = new ImageIcon(cancelImage);
        CANCEL_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)cancelImage, (float)0.53f));
        BufferedImage sortImage = ImageUtil.loadImageResource(PurchaseProgressPlugin.class, (String)"/sort_icon.png");
        SORT_ICON = new ImageIcon(sortImage);
        SORT_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)sortImage, (float)0.53f));
    }
}

