/*
 * Decompiled with CFR 0.152.
 */
package com.brastasauce.purchaseprogress.ui;

import com.brastasauce.purchaseprogress.PurchaseProgressPlugin;
import com.brastasauce.purchaseprogress.data.PurchaseProgressItem;
import com.brastasauce.purchaseprogress.ui.PurchaseProgressPluginPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;

public class PurchaseProgressItemPanel
extends JPanel {
    private static final String DELETE_TITLE = "Warning";
    private static final String DELETE_MESSAGE = "Are you sure you want to delete this progress item?";
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_HOVER_ICON;
    private static final ImageIcon SHIFT_UP_ICON;
    private static final ImageIcon SHIFT_UP_HOVER_ICON;
    private static final ImageIcon SHIFT_DOWN_ICON;
    private static final ImageIcon SHIFT_DOWN_HOVER_ICON;
    private static final Dimension IMAGE_SIZE;
    private float percent;

    PurchaseProgressItemPanel(final PurchaseProgressPlugin plugin, final PurchaseProgressItem item) {
        this.setLayout(new BorderLayout(5, 0));
        this.setBorder(new EmptyBorder(5, 5, 5, 0));
        final int itemIndex = plugin.getItems().indexOf(item);
        final int itemsSize = plugin.getItems().size();
        JLabel itemImage = new JLabel();
        itemImage.setPreferredSize(IMAGE_SIZE);
        if (item.getImage() != null) {
            item.getImage().addTo(itemImage);
        }
        this.add((Component)itemImage, "Before");
        JPanel rightPanel = new JPanel(new GridLayout(3, 1));
        rightPanel.setBackground(new Color(0, 0, 0, 0));
        JLabel itemName = new JLabel();
        itemName.setForeground(Color.WHITE);
        itemName.setMaximumSize(new Dimension(0, 0));
        itemName.setPreferredSize(new Dimension(0, 0));
        itemName.setText(item.getName());
        rightPanel.add(itemName);
        JLabel gePriceLabel = new JLabel();
        if (item.getGePrice() > 0) {
            gePriceLabel.setText(QuantityFormatter.formatNumber((long)item.getGePrice()) + " gp");
        } else {
            gePriceLabel.setText("N/A");
        }
        gePriceLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        rightPanel.add(gePriceLabel);
        JLabel progressLabel = new JLabel();
        this.percent = (float)plugin.getValue() / (float)item.getGePrice() * 100.0f;
        if (this.percent >= 100.0f) {
            this.percent = 100.0f;
        }
        progressLabel.setText(String.format("%.0f", Float.valueOf(this.percent)) + "%");
        rightPanel.add(progressLabel);
        JPanel actionPanel = new JPanel(new BorderLayout());
        actionPanel.setBackground(new Color(0, 0, 0, 0));
        actionPanel.setOpaque(false);
        final JLabel deleteItem = new JLabel(DELETE_ICON);
        deleteItem.setBorder(new EmptyBorder(0, 15, 0, 0));
        deleteItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (PurchaseProgressItemPanel.this.deleteConfirm()) {
                    plugin.removeItem(item);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                deleteItem.setIcon(DELETE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                deleteItem.setIcon(DELETE_ICON);
            }
        });
        actionPanel.add((Component)deleteItem, "North");
        JPanel shiftItemPanel = new JPanel(new BorderLayout());
        shiftItemPanel.setOpaque(false);
        final JLabel shiftUp = new JLabel(SHIFT_UP_ICON);
        shiftUp.setBorder(new EmptyBorder(0, 0, 0, 5));
        if (itemIndex == 0) {
            shiftUp.setIcon(SHIFT_UP_HOVER_ICON);
        }
        shiftUp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (itemIndex != 0) {
                    plugin.shiftItem(itemIndex, true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                shiftUp.setIcon(SHIFT_UP_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (itemIndex != 0) {
                    shiftUp.setIcon(SHIFT_UP_ICON);
                }
            }
        });
        shiftItemPanel.add((Component)shiftUp, "West");
        final JLabel shiftDown = new JLabel(SHIFT_DOWN_ICON);
        shiftDown.setBorder(new EmptyBorder(0, 0, 0, 5));
        if (itemIndex == itemsSize - 1) {
            shiftDown.setIcon(SHIFT_DOWN_HOVER_ICON);
        }
        shiftDown.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (itemIndex != itemsSize - 1) {
                    plugin.shiftItem(itemIndex, false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                shiftDown.setIcon(SHIFT_DOWN_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (itemIndex != itemsSize - 1) {
                    shiftDown.setIcon(SHIFT_DOWN_ICON);
                }
            }
        });
        shiftItemPanel.add((Component)shiftDown, "East");
        actionPanel.add((Component)shiftItemPanel, "South");
        this.add((Component)rightPanel, "Center");
        this.add((Component)actionPanel, "East");
    }

    private boolean deleteConfirm() {
        int confirm = JOptionPane.showConfirmDialog(this, DELETE_MESSAGE, DELETE_TITLE, 0);
        return confirm == 0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(new Color(12, 85, 35));
        int greenWidth = (int)((float)this.getWidth() * this.percent / 100.0f);
        g.fillRect(0, 0, greenWidth, this.getHeight());
        if (greenWidth != this.getWidth()) {
            g.setColor(ColorScheme.DARKER_GRAY_COLOR);
            g.fillRect(greenWidth, 0, this.getWidth() - greenWidth, this.getHeight());
        }
    }

    static {
        IMAGE_SIZE = new Dimension(32, 32);
        BufferedImage deleteImage = ImageUtil.loadImageResource(PurchaseProgressPluginPanel.class, (String)"/delete_icon.png");
        DELETE_ICON = new ImageIcon(deleteImage);
        DELETE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteImage, (float)0.53f));
        BufferedImage shiftUpImage = ImageUtil.loadImageResource(PurchaseProgressPlugin.class, (String)"/shift_up_icon.png");
        SHIFT_UP_ICON = new ImageIcon(shiftUpImage);
        SHIFT_UP_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)shiftUpImage, (float)0.53f));
        BufferedImage shiftDownImage = ImageUtil.loadImageResource(PurchaseProgressPlugin.class, (String)"/shift_down_icon.png");
        SHIFT_DOWN_ICON = new ImageIcon(shiftDownImage);
        SHIFT_DOWN_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)shiftDownImage, (float)0.53f));
    }
}

