/*
 * Decompiled with CFR 0.152.
 */
package com.brastasauce.purchaseprogress.ui;

import com.brastasauce.purchaseprogress.PurchaseProgressPlugin;
import com.brastasauce.purchaseprogress.data.PurchaseProgressGroup;
import com.brastasauce.purchaseprogress.data.PurchaseProgressItem;
import com.brastasauce.purchaseprogress.ui.PurchaseProgressGroupItemPanel;
import com.brastasauce.purchaseprogress.ui.PurchaseProgressPluginPanel;
import com.brastasauce.purchaseprogress.ui.PurchaseProgressSelectionPanel;
import com.brastasauce.purchaseprogress.ui.PurchaseProgressTotalPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class PurchaseProgressGroupPanel
extends JPanel {
    private static final String DELETE_TITLE = "Warning";
    private static final String DELETE_MESSAGE = "Are you sure you want to delete this progress group? This will not delete your items.";
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private static final ImageIcon COLLAPSED_ICON;
    private static final ImageIcon COLLAPSED_HOVER_ICON;
    private static final ImageIcon UNCOLLAPSED_ICON;
    private static final ImageIcon UNCOLLAPSED_HOVER_ICON;
    private float percent;
    private final boolean collapsed;
    private long totalCost;

    PurchaseProgressGroupPanel(final PurchaseProgressPlugin plugin, final PurchaseProgressPluginPanel panel, final PurchaseProgressGroup group) {
        this.setLayout(new BorderLayout(5, 0));
        this.setBorder(new EmptyBorder(5, 5, 5, 0));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        for (PurchaseProgressItem item : group.getItems()) {
            this.totalCost += (long)item.getGePrice();
        }
        this.collapsed = group.isCollapsed();
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setOpaque(false);
        final JPopupMenu deletePopup = new JPopupMenu();
        JMenuItem delete = new JMenuItem(new AbstractAction("Delete Group"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PurchaseProgressGroupPanel.this.deleteConfirm()) {
                    plugin.removeGroup(group);
                }
            }
        });
        deletePopup.add(delete);
        topPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    deletePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JPanel leftActions = new JPanel(new BorderLayout());
        leftActions.setOpaque(false);
        JLabel groupName = new JLabel();
        groupName.setForeground(Color.WHITE);
        groupName.setBorder(new EmptyBorder(0, 5, 0, 0));
        groupName.setPreferredSize(new Dimension(140, 0));
        groupName.setText(group.getName());
        final JLabel collapseButton = new JLabel();
        collapseButton.setOpaque(false);
        if (this.collapsed) {
            groupName.setPreferredSize(new Dimension(160, 0));
            collapseButton.setIcon(COLLAPSED_ICON);
            collapseButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    plugin.switchGroupCollapse(group);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    collapseButton.setIcon(COLLAPSED_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    collapseButton.setIcon(COLLAPSED_ICON);
                }
            });
            leftActions.add((Component)groupName, "East");
            leftActions.add((Component)collapseButton, "West");
            JLabel percentLabel = new JLabel();
            percentLabel.setBorder(new EmptyBorder(0, 0, 0, 5));
            this.percent = (float)plugin.getValue() / (float)this.totalCost * 100.0f;
            if (this.totalCost == 0L) {
                this.percent = 0.0f;
            } else if (this.percent >= 100.0f) {
                this.percent = 100.0f;
            }
            percentLabel.setText(String.format("%.0f", Float.valueOf(this.percent)) + "%");
            topPanel.add((Component)leftActions, "West");
            topPanel.add((Component)percentLabel, "East");
            this.add((Component)topPanel, "Center");
        } else {
            collapseButton.setIcon(UNCOLLAPSED_ICON);
            collapseButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    plugin.switchGroupCollapse(group);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    collapseButton.setIcon(UNCOLLAPSED_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    collapseButton.setIcon(UNCOLLAPSED_ICON);
                }
            });
            leftActions.add((Component)groupName, "East");
            leftActions.add((Component)collapseButton, "West");
            topPanel.add((Component)leftActions, "West");
            JPanel rightActions = new JPanel(new BorderLayout());
            rightActions.setBorder(new EmptyBorder(0, 0, 0, 5));
            rightActions.setOpaque(false);
            final JLabel edit = new JLabel("Edit");
            edit.setVerticalAlignment(0);
            edit.setBorder(new EmptyBorder(0, 0, 0, 0));
            edit.setForeground(Color.LIGHT_GRAY);
            edit.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    plugin.editGroup(group);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    edit.setForeground(Color.WHITE);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    edit.setForeground(Color.LIGHT_GRAY);
                }
            });
            rightActions.add((Component)edit, "West");
            JPanel empty = new JPanel();
            empty.setOpaque(false);
            rightActions.add((Component)empty, "Center");
            final JLabel addItem = new JLabel(ADD_ICON);
            addItem.setOpaque(false);
            addItem.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    String[] itemNames = (String[])plugin.getItems().stream().map(PurchaseProgressItem::getName).toArray(String[]::new);
                    Arrays.sort(itemNames, String.CASE_INSENSITIVE_ORDER);
                    PurchaseProgressSelectionPanel selection = new PurchaseProgressSelectionPanel((JPanel)((Object)panel), itemNames);
                    selection.setOnOk(e1 -> {
                        List<String> selectedItems = selection.getSelectedItems();
                        if (!selectedItems.isEmpty()) {
                            plugin.addItemsToGroup(group, selectedItems);
                        }
                    });
                    selection.show();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    addItem.setIcon(ADD_HOVER_ICON);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    addItem.setIcon(ADD_ICON);
                }
            });
            rightActions.add((Component)addItem, "East");
            topPanel.add((Component)rightActions, "East");
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.gridwidth = 1;
            constraints.weightx = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 1;
            JPanel itemsPanel = new JPanel();
            itemsPanel.setLayout(new GridBagLayout());
            itemsPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
            itemsPanel.setOpaque(false);
            int index = 0;
            for (PurchaseProgressItem item : group.getItems()) {
                PurchaseProgressGroupItemPanel itemPanel = new PurchaseProgressGroupItemPanel(plugin, group, item);
                if (index++ > 0) {
                    itemsPanel.add((Component)this.createMarginWrapper(itemPanel), constraints);
                } else {
                    itemsPanel.add((Component)itemPanel, constraints);
                }
                ++constraints.gridy;
            }
            if (this.totalCost != 0L) {
                PurchaseProgressTotalPanel totalPanel = new PurchaseProgressTotalPanel(plugin.getValue(), this.totalCost, ColorScheme.DARK_GRAY_COLOR);
                itemsPanel.add((Component)this.createMarginWrapper(totalPanel), constraints);
            }
            this.add((Component)topPanel, "North");
            this.add((Component)itemsPanel, "Center");
        }
    }

    private boolean deleteConfirm() {
        int confirm = JOptionPane.showConfirmDialog(this, DELETE_MESSAGE, DELETE_TITLE, 0);
        return confirm == 0;
    }

    private JPanel createMarginWrapper(JPanel panel) {
        JPanel marginWrapper = new JPanel(new BorderLayout());
        marginWrapper.setOpaque(false);
        marginWrapper.setBorder(new EmptyBorder(5, 0, 0, 0));
        marginWrapper.add((Component)panel, "North");
        return marginWrapper;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.collapsed) {
            g.setColor(new Color(12, 85, 35));
            int greenWidth = (int)((float)this.getWidth() * this.percent / 100.0f);
            g.fillRect(0, 0, greenWidth, this.getHeight());
            if (greenWidth != this.getWidth()) {
                g.setColor(ColorScheme.DARKER_GRAY_COLOR);
                g.fillRect(greenWidth, 0, this.getWidth() - greenWidth, this.getHeight());
            }
        } else {
            g.setColor(ColorScheme.DARKER_GRAY_COLOR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public long getTotalCost() {
        return this.totalCost;
    }

    static {
        BufferedImage addImage = ImageUtil.loadImageResource(PurchaseProgressPluginPanel.class, (String)"/add_icon_white.png");
        ADD_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addImage, (float)0.53f));
        ADD_HOVER_ICON = new ImageIcon(addImage);
        BufferedImage collapsedImage = ImageUtil.loadImageResource(PurchaseProgressPluginPanel.class, (String)"/collapsed_icon.png");
        COLLAPSED_ICON = new ImageIcon(collapsedImage);
        COLLAPSED_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)collapsedImage, (float)0.53f));
        BufferedImage uncollapsedImage = ImageUtil.loadImageResource(PurchaseProgressPluginPanel.class, (String)"/shift_down_icon.png");
        UNCOLLAPSED_ICON = new ImageIcon(uncollapsedImage);
        UNCOLLAPSED_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)uncollapsedImage, (float)0.53f));
    }
}

