/*
 * Decompiled with CFR 0.152.
 */
package com.brastasauce.purchaseprogress.data;

import com.brastasauce.purchaseprogress.PurchaseProgressPlugin;
import com.brastasauce.purchaseprogress.data.PurchaseProgressGroup;
import com.brastasauce.purchaseprogress.data.PurchaseProgressGroupData;
import com.brastasauce.purchaseprogress.data.PurchaseProgressItem;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseProgressDataManager {
    private static final Logger log = LoggerFactory.getLogger(PurchaseProgressDataManager.class);
    private static final String CONFIG_KEY_VALUE = "value";
    private static final String CONFIG_KEY_ITEMIDS = "itemIds";
    private static final String CONFIG_KEY_GROUPS = "groups";
    private final PurchaseProgressPlugin plugin;
    private final Client client;
    private final ConfigManager configManager;
    private final ItemManager itemManager;
    private final Gson gson;
    private List<Integer> itemIds = new ArrayList<Integer>();
    private final Type itemsType = new TypeToken<ArrayList<Integer>>(){}.getType();
    private List<PurchaseProgressGroupData> groups = new ArrayList<PurchaseProgressGroupData>();
    private final Type groupsType = new TypeToken<ArrayList<PurchaseProgressGroupData>>(){}.getType();

    @Inject
    public PurchaseProgressDataManager(PurchaseProgressPlugin plugin, Client client, ConfigManager configManager, ItemManager itemManager, Gson gson) {
        this.plugin = plugin;
        this.client = client;
        this.configManager = configManager;
        this.itemManager = itemManager;
        this.gson = gson;
    }

    public boolean loadData() {
        if (this.client.getGameState().getState() < GameState.LOGIN_SCREEN.getState()) {
            return false;
        }
        String value = this.configManager.getConfiguration("purchaseprogress", CONFIG_KEY_VALUE);
        this.plugin.setValue(Long.parseLong(value));
        this.itemIds.clear();
        String itemsJson = this.configManager.getConfiguration("purchaseprogress", CONFIG_KEY_ITEMIDS);
        if (itemsJson == null || itemsJson.equals("[]")) {
            this.plugin.setItems(new ArrayList<PurchaseProgressItem>());
        } else {
            try {
                this.itemIds = (List)this.gson.fromJson(itemsJson, this.itemsType);
                this.convertItems();
            }
            catch (Exception e) {
                log.error("Exception occurred while loading purchase progress items", (Throwable)e);
                this.plugin.setItems(new ArrayList<PurchaseProgressItem>());
            }
        }
        this.groups.clear();
        String groupsJson = this.configManager.getConfiguration("purchaseprogress", CONFIG_KEY_GROUPS);
        if (groupsJson == null || groupsJson.equals("[]")) {
            this.plugin.setGroups(new ArrayList<PurchaseProgressGroup>());
        } else {
            try {
                this.groups = (List)this.gson.fromJson(groupsJson, this.groupsType);
                this.convertGroups();
            }
            catch (Exception e) {
                log.error("Exception occurred while loading purchase progress groups", (Throwable)e);
                this.plugin.setGroups(new ArrayList<PurchaseProgressGroup>());
            }
        }
        this.plugin.updateItemPrices();
        return true;
    }

    public void saveData() {
        this.configManager.setConfiguration("purchaseprogress", CONFIG_KEY_VALUE, String.valueOf(this.plugin.getValue()));
        this.itemIds.clear();
        for (PurchaseProgressItem purchaseProgressItem : this.plugin.getItems()) {
            this.itemIds.add(purchaseProgressItem.getItemId());
        }
        String itemsJson = this.gson.toJson(this.itemIds);
        this.configManager.setConfiguration("purchaseprogress", CONFIG_KEY_ITEMIDS, itemsJson);
        this.groups.clear();
        for (PurchaseProgressGroup group : this.plugin.getGroups()) {
            ArrayList<Integer> groupItems = new ArrayList<Integer>();
            for (PurchaseProgressItem item : group.getItems()) {
                groupItems.add(item.getItemId());
            }
            this.groups.add(new PurchaseProgressGroupData(group.getName(), group.isCollapsed(), groupItems));
        }
        String string = this.gson.toJson(this.groups);
        this.configManager.setConfiguration("purchaseprogress", CONFIG_KEY_GROUPS, string);
    }

    private void convertItems() {
        ArrayList<PurchaseProgressItem> progressItems = new ArrayList<PurchaseProgressItem>();
        for (Integer itemId : this.itemIds) {
            progressItems.add(this.convertIdToItem(itemId));
        }
        this.plugin.setItems(progressItems);
    }

    private void convertGroups() {
        ArrayList<PurchaseProgressGroup> progressGroups = new ArrayList<PurchaseProgressGroup>();
        for (PurchaseProgressGroupData group : this.groups) {
            ArrayList<PurchaseProgressItem> groupItems = new ArrayList<PurchaseProgressItem>();
            for (Integer itemId : group.getItems()) {
                groupItems.add(this.convertIdToItem(itemId));
            }
            progressGroups.add(new PurchaseProgressGroup(group.getName(), group.isCollapsed(), groupItems));
        }
        this.plugin.setGroups(progressGroups);
    }

    private PurchaseProgressItem convertIdToItem(int itemId) {
        AsyncBufferedImage itemImage = this.itemManager.getImage(itemId);
        String itemName = this.itemManager.getItemComposition(itemId).getName();
        return new PurchaseProgressItem(itemImage, itemName, itemId, 0);
    }
}

