/*
 * Decompiled with CFR 0.152.
 */
package com.brastasauce.purchaseprogress;

import com.brastasauce.purchaseprogress.BankCalculation;
import com.brastasauce.purchaseprogress.PurchaseProgressConfig;
import com.brastasauce.purchaseprogress.data.PurchaseProgressDataManager;
import com.brastasauce.purchaseprogress.data.PurchaseProgressGroup;
import com.brastasauce.purchaseprogress.data.PurchaseProgressItem;
import com.brastasauce.purchaseprogress.ui.PurchaseProgressPluginPanel;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Purchase Progress")
public class PurchaseProgressPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PurchaseProgressPlugin.class);
    public static final String CONFIG_GROUP = "purchaseprogress";
    private static final String PLUGIN_NAME = "Purchase Progress";
    private static final String ICON_IMAGE = "/panel_icon.png";
    private static final int MAX_GROUP_NAME_LENGTH = 50;
    private List<PurchaseProgressItem> items = new ArrayList<PurchaseProgressItem>();
    private List<PurchaseProgressGroup> groups = new ArrayList<PurchaseProgressGroup>();
    private long value = 0L;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private BankCalculation bankCalculation;
    @Inject
    private Gson gson;
    @Inject
    private PurchaseProgressDataManager dataManager;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private Client client;
    @Inject
    private PurchaseProgressConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    private PurchaseProgressPluginPanel panel;
    private NavigationButton navButton;

    public void addItem(PurchaseProgressItem item) {
        this.clientThread.invokeLater(() -> {
            if (!this.containsItem(item)) {
                this.items.add(item);
                this.dataManager.saveData();
                SwingUtilities.invokeLater(() -> {
                    this.panel.switchToProgress();
                    this.panel.updateProgressPanels();
                });
            } else {
                SwingUtilities.invokeLater(() -> this.panel.containsItemWarning());
            }
        });
    }

    public void removeItem(PurchaseProgressItem item) {
        this.clientThread.invokeLater(() -> {
            this.items.remove(item);
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateProgressPanels());
        });
    }

    public void addGroup() {
        String msg = "Enter the name of this group (max 50 chars).";
        String name = JOptionPane.showInputDialog((Component)((Object)this.panel), "Enter the name of this group (max 50 chars).", "Add New Group", -1);
        if (name == null || name.isEmpty()) {
            return;
        }
        if (name.length() > 50) {
            name = name.substring(0, 50);
        }
        String groupName = name;
        this.clientThread.invokeLater(() -> {
            PurchaseProgressGroup group = new PurchaseProgressGroup(groupName, new ArrayList<PurchaseProgressItem>());
            if (!this.groups.contains(group)) {
                this.groups.add(group);
                this.dataManager.saveData();
                SwingUtilities.invokeLater(() -> this.panel.updateProgressPanels());
            }
        });
    }

    public void editGroup(PurchaseProgressGroup group) {
        String msg = "Enter the name of this group (max 50 chars).";
        String name = JOptionPane.showInputDialog((Component)((Object)this.panel), "Enter the name of this group (max 50 chars).", "Edit Group", -1);
        if (name == null || name.isEmpty()) {
            return;
        }
        if (name.length() > 50) {
            name = name.substring(0, 50);
        }
        String groupName = name;
        this.clientThread.invokeLater(() -> {
            PurchaseProgressGroup nameCheck = this.groups.stream().filter(o -> o.getName().equals(groupName)).findFirst().orElse(null);
            if (nameCheck == null) {
                group.setName(groupName);
                this.dataManager.saveData();
                SwingUtilities.invokeLater(() -> this.panel.updateProgressPanels());
            }
        });
    }

    public void removeGroup(PurchaseProgressGroup group) {
        this.clientThread.invokeLater(() -> {
            this.items.addAll(group.getItems());
            this.groups.remove(group);
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateProgressPanels());
        });
    }

    public void addItemsToGroup(PurchaseProgressGroup group, List<String> itemNames) {
        this.clientThread.invokeLater(() -> {
            for (String itemName : itemNames) {
                PurchaseProgressItem item = this.items.stream().filter(o -> o.getName().equals(itemName)).findFirst().orElse(null);
                group.getItems().add(item);
                this.items.remove(item);
            }
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateProgressPanels());
        });
    }

    public void removeItemFromGroup(PurchaseProgressGroup group, PurchaseProgressItem item) {
        this.clientThread.invokeLater(() -> {
            group.getItems().remove(item);
            this.items.add(item);
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateProgressPanels());
        });
    }

    public void switchGroupCollapse(PurchaseProgressGroup group) {
        this.clientThread.invokeLater(() -> {
            group.setCollapsed(!group.isCollapsed());
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateProgressPanels());
        });
    }

    @Schedule(period=5L, unit=ChronoUnit.MINUTES)
    public void updateItemPrices() {
        for (PurchaseProgressGroup group : this.groups) {
            for (PurchaseProgressItem item : group.getItems()) {
                item.setGePrice(this.itemManager.getItemPrice(item.getItemId()));
            }
        }
        for (PurchaseProgressItem item : this.items) {
            item.setGePrice(this.itemManager.getItemPrice(item.getItemId()));
        }
        SwingUtilities.invokeLater(() -> this.panel.updateProgressPanels());
    }

    public void sort(boolean sortAscending) {
        this.clientThread.invokeLater(() -> {
            if (!this.items.isEmpty()) {
                if (sortAscending) {
                    this.items.sort(Comparator.naturalOrder());
                } else {
                    this.items.sort(Comparator.reverseOrder());
                }
                this.dataManager.saveData();
                SwingUtilities.invokeLater(() -> this.panel.updateProgressPanels());
            }
        });
    }

    public void shiftItem(int itemIndex, boolean shiftUp) {
        this.clientThread.invokeLater(() -> {
            PurchaseProgressItem shiftedItem = this.items.get(itemIndex);
            if (shiftUp) {
                this.items.set(itemIndex, this.items.get(itemIndex - 1));
                this.items.set(itemIndex - 1, shiftedItem);
            } else {
                this.items.set(itemIndex, this.items.get(itemIndex + 1));
                this.items.set(itemIndex + 1, shiftedItem);
            }
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateProgressPanels());
        });
    }

    public void shiftItemInGroup(PurchaseProgressGroup group, int itemIndex, boolean shiftUp) {
        this.clientThread.invokeLater(() -> {
            List<PurchaseProgressItem> groupItems = group.getItems();
            PurchaseProgressItem shiftedItem = group.getItems().get(itemIndex);
            if (shiftUp) {
                groupItems.set(itemIndex, groupItems.get(itemIndex - 1));
                groupItems.set(itemIndex - 1, shiftedItem);
            } else {
                groupItems.set(itemIndex, groupItems.get(itemIndex + 1));
                groupItems.set(itemIndex + 1, shiftedItem);
            }
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateProgressPanels());
        });
    }

    private boolean containsItem(PurchaseProgressItem newItem) {
        for (PurchaseProgressGroup group : this.groups) {
            if (!group.getItems().contains(newItem)) continue;
            return true;
        }
        return this.items.contains(newItem);
    }

    protected void startUp() throws Exception {
        this.panel = (PurchaseProgressPluginPanel)((Object)this.injector.getInstance(PurchaseProgressPluginPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(PurchaseProgressPlugin.class, (String)ICON_IMAGE);
        this.navButton = NavigationButton.builder().tooltip(PLUGIN_NAME).icon(icon).priority(9).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.dataManager = new PurchaseProgressDataManager(this, this.client, this.configManager, this.itemManager, this.gson);
        this.clientThread.invokeLater(() -> this.dataManager.loadData());
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Provides
    PurchaseProgressConfig provideConfig(ConfigManager configManager) {
        return (PurchaseProgressConfig)configManager.getConfig(PurchaseProgressConfig.class);
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 277) {
            this.value = this.bankCalculation.calculateValue();
            this.dataManager.saveData();
            SwingUtilities.invokeLater(() -> this.panel.updateProgressPanels());
        }
    }

    public List<PurchaseProgressItem> getItems() {
        return this.items;
    }

    public void setItems(List<PurchaseProgressItem> items) {
        this.items = items;
    }

    public List<PurchaseProgressGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<PurchaseProgressGroup> groups) {
        this.groups = groups;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }
}

