/*
 * Decompiled with CFR 0.152.
 */
package com.brastasauce.purchaseprogress;

import com.brastasauce.purchaseprogress.PurchaseProgressConfig;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemManager;

public class BankCalculation {
    private int hash;
    private Long bankValue;
    private static final List<Integer> TAB_VARBITS = ImmutableList.of((Object)4171, (Object)4172, (Object)4173, (Object)4174, (Object)4175, (Object)4176, (Object)4177, (Object)4178, (Object)4179);
    @Inject
    private ItemManager itemManager;
    @Inject
    private Client client;
    @Inject
    private PurchaseProgressConfig config;

    long calculateValue() {
        long value = 0L;
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        ItemContainer bank = this.client.getItemContainer(InventoryID.BANK);
        if (inventory != null) {
            value += (long)inventory.count(995);
            value += (long)inventory.count(13204) * 1000L;
        }
        if (bank == null) {
            return value;
        }
        value += (long)bank.count(995);
        value += (long)bank.count(13204) * 1000L;
        if (!this.config.includeBankTab()) {
            return value;
        }
        Item[] items = bank.getItems();
        int lootTab = this.config.bankTab();
        if (lootTab != 0) {
            int startIndex = 0;
            for (int i = lootTab - 1; i > 0; --i) {
                startIndex += this.client.getVarbitValue(TAB_VARBITS.get(i - 1).intValue());
            }
            int itemCount = this.client.getVarbitValue(TAB_VARBITS.get(lootTab - 1).intValue());
            value += this.calculateItemValues(Arrays.copyOfRange(items, startIndex, startIndex + itemCount));
        } else {
            value += this.calculateItemValues(items);
        }
        return value;
    }

    private long calculateItemValues(Item[] items) {
        int newHash = this.hashItems(items);
        if (this.bankValue != null && this.hash == newHash) {
            return this.bankValue;
        }
        this.hash = newHash;
        long value = 0L;
        block4: for (Item item : items) {
            int qty = item.getQuantity();
            int id = item.getId();
            if (id <= 0 || qty == 0) continue;
            switch (id) {
                case 995: {
                    continue block4;
                }
                case 13204: {
                    continue block4;
                }
                default: {
                    value += (long)this.itemManager.getItemPrice(id) * (long)qty;
                }
            }
        }
        this.bankValue = value;
        return value;
    }

    private int hashItems(Item[] items) {
        HashMap<Integer, Integer> mapCheck = new HashMap<Integer, Integer>(items.length);
        for (Item item : items) {
            mapCheck.put(item.getId(), item.getQuantity());
        }
        return mapCheck.hashCode();
    }
}

