/*
 * Decompiled with CFR 0.152.
 */
package easyunnote;

import com.google.inject.Provides;
import easyunnote.EasyUnnoteConfig;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.api.events.ClientTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Easy Unnote")
public class EasyUnnotePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EasyUnnotePlugin.class);
    private static final String[] UNNOTE_OBJECTS = new String[]{"Bank chest", "Bank Chest-wreck"};
    private static final String[] UNNOTE_NPCS = new String[]{"Aisles", "Banknote Exchange Merchant", "Elder Chaos druid", "Phials", "Piles", "Tiles", "Wesley", "Rick", "Maid", "Cook", "Butler", "Demon butler"};
    private static final String[] BANKNOTE_LIKE = new String[]{"Looting bag note", "Rune pouch note"};
    @Inject
    private Client client;
    @Inject
    private EasyUnnoteConfig config;

    @Provides
    EasyUnnoteConfig provideConfig(ConfigManager configManager) {
        return (EasyUnnoteConfig)configManager.getConfig(EasyUnnoteConfig.class);
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        Widget selectedWidget = this.client.getSelectedWidget();
        if (selectedWidget == null) {
            return;
        }
        if (selectedWidget.getId() != WidgetInfo.INVENTORY.getId()) {
            return;
        }
        int itemId = selectedWidget.getItemId();
        if (itemId <= 0 || !this.client.isWidgetSelected()) {
            return;
        }
        ItemComposition itemComposition = this.client.getItemDefinition(itemId);
        if (!this.canUnnote(itemComposition)) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        MenuEntry[] newEntries = (MenuEntry[])Arrays.stream(menuEntries).filter(e -> {
            switch (e.getType()) {
                case WIDGET_TARGET_ON_GROUND_ITEM: 
                case WIDGET_TARGET_ON_PLAYER: 
                case EXAMINE_NPC: 
                case EXAMINE_OBJECT: 
                case EXAMINE_ITEM_GROUND: {
                    return false;
                }
                case WIDGET_TARGET_ON_GAME_OBJECT: {
                    TileObject gameObject = this.findObject(e.getParam0(), e.getParam1(), e.getIdentifier());
                    if (gameObject == null) {
                        return false;
                    }
                    ObjectComposition composition = this.client.getObjectDefinition(gameObject.getId());
                    return this.canUnnote(composition);
                }
                case WIDGET_TARGET_ON_NPC: {
                    NPC npc = e.getNpc();
                    return this.canUnnote(npc.getTransformedComposition());
                }
            }
            return true;
        }).toArray(MenuEntry[]::new);
        this.client.setMenuEntries(newEntries);
    }

    private TileObject findObject(int x, int y, int id) {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        Tile tile = tiles[this.client.getPlane()][x][y];
        if (tile != null) {
            for (GameObject gameObject : tile.getGameObjects()) {
                if (gameObject == null || gameObject.getId() != id) continue;
                return gameObject;
            }
            WallObject wallObject = tile.getWallObject();
            if (wallObject != null && wallObject.getId() == id) {
                return wallObject;
            }
        }
        return null;
    }

    private boolean canUnnote(ItemComposition item) {
        if (item.getNote() != -1) {
            return true;
        }
        return Arrays.stream(BANKNOTE_LIKE).anyMatch(item.getName()::equals);
    }

    private boolean canUnnote(ObjectComposition object) {
        if (object.getImpostorIds() != null) {
            object = object.getImpostor();
        }
        if (Arrays.stream(UNNOTE_OBJECTS).anyMatch(object.getName()::equalsIgnoreCase)) {
            return true;
        }
        if ("Grand Exchange booth".equalsIgnoreCase(object.getName())) {
            return this.config.enableGEBooths();
        }
        if (object.getName().toLowerCase().endsWith("table") || "Counter".equalsIgnoreCase(object.getName())) {
            return this.config.enableTables();
        }
        return Arrays.stream(object.getActions()).anyMatch("Bank"::equalsIgnoreCase);
    }

    private boolean canUnnote(NPCComposition npc) {
        if (Arrays.stream(UNNOTE_NPCS).anyMatch(npc.getName()::equalsIgnoreCase)) {
            return true;
        }
        return Arrays.stream(npc.getActions()).anyMatch("Bank"::equalsIgnoreCase);
    }
}

