/*
 * Decompiled with CFR 0.152.
 */
package com.ImpoliteSlayer;

import com.ImpoliteSlayer.ImpoliteSlayerConfig;
import com.google.inject.Provides;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.slayer.SlayerPlugin;
import net.runelite.client.plugins.slayer.SlayerPluginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Impolite Slayer")
@PluginDependency(value=SlayerPlugin.class)
public class ImpoliteSlayerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ImpoliteSlayerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ImpoliteSlayerConfig config;
    @Inject
    private SlayerPluginService slayerPluginService;
    private List<String> badTasks;
    private Widget[] dialogueOptions;

    protected void startUp() {
        this.initImpoliteSlayer();
    }

    private void initImpoliteSlayer() {
        log.debug("Loading Impolite Slayer config...");
        this.badTasks = Arrays.asList(this.config.badTasks().split(","));
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        Widget playerDialogueOptionsWidget;
        String playerText;
        String task = this.slayerPluginService.getTask();
        if (!this.badTasks.contains(task)) {
            return;
        }
        Widget playerDialogueTextWidget = this.client.getWidget(WidgetInfo.DIALOG_PLAYER_TEXT);
        if (playerDialogueTextWidget != null && (playerText = playerDialogueTextWidget.getText()).equals("Okay, great!")) {
            playerDialogueTextWidget.setText(this.config.message());
        }
        if ((playerDialogueOptionsWidget = this.client.getWidget(219, 1)) != null && playerDialogueOptionsWidget.getChildren() != this.dialogueOptions) {
            for (Widget dialogueOption : this.dialogueOptions = playerDialogueOptionsWidget.getChildren()) {
                if (!dialogueOption.getText().equals("Okay, great!")) continue;
                dialogueOption.setText(this.config.message());
            }
            this.dialogueOptions = playerDialogueOptionsWidget.getChildren();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("impolite-slayer")) {
            this.initImpoliteSlayer();
        }
    }

    @Provides
    ImpoliteSlayerConfig provideConfig(ConfigManager configManager) {
        return (ImpoliteSlayerConfig)configManager.getConfig(ImpoliteSlayerConfig.class);
    }
}

