/*
 * Decompiled with CFR 0.152.
 */
package com.slayerassistant.userinterface;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import lombok.NonNull;

public class Table {
    private final String[] headers;
    private final Object[][] data;
    private final JScrollPane table;

    public Table(@NonNull String[] headers, Object[] ... data) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.headers = headers;
        this.data = data;
        JTable table = this.createTable();
        this.table = this.createScrollPane(table);
    }

    private JScrollPane createScrollPane(Component table) {
        JScrollPane scrollPane = new JScrollPane(table);
        Color bg = new Color(35, 35, 35);
        scrollPane.setBackground(bg);
        scrollPane.getViewport().setBackground(bg);
        Border bevelBorder = BorderFactory.createBevelBorder(1);
        Border emptyBorder = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(bevelBorder, emptyBorder);
        scrollPane.setBorder(compoundBorder);
        return scrollPane;
    }

    private JTable createTable() {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(2);
        renderer.setForeground(Color.LIGHT_GRAY);
        JTable table = new JTable(new DefaultTableModel(this.headers, 0));
        for (String header : this.headers) {
            table.getColumn(header).setHeaderRenderer(renderer);
        }
        table.getTableHeader().setPreferredSize(new Dimension(0, 20));
        table.setGridColor(new Color(25, 25, 25));
        table.setBackground(Color.BLACK);
        table.setEnabled(false);
        table.setRowHeight(20);
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        this.populateRows(model);
        return table;
    }

    private void populateRows(DefaultTableModel model) {
        Object[] largest = this.getLargestDataset(this.data);
        for (int i = 0; i < largest.length; ++i) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (Object[] datum : this.data) {
                row.add(i > datum.length - 1 ? "" : datum[i]);
            }
            model.addRow(row.toArray());
        }
    }

    private Object[] getLargestDataset(Object[][] datasets) {
        Object[] largest = datasets[0];
        for (Object[] dataset : datasets) {
            if (dataset.length <= largest.length) continue;
            largest = dataset;
        }
        return largest;
    }

    public JScrollPane getTable() {
        return this.table;
    }
}

