/*
 * Decompiled with CFR 0.152.
 */
package com.slayerassistant.userinterface;

import com.slayerassistant.domain.SlayerTask;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class SelectList<T> {
    private final JList<T> items = new JList();

    public SelectList(ListCellRenderer<T> listCellRenderer, Consumer<SlayerTask> onClickHandler) {
        Objects.requireNonNull(onClickHandler, "Click handler cannot be null");
        this.items.setCellRenderer(listCellRenderer);
        this.items.addMouseListener(this.getMouseAdapter(onClickHandler));
        this.items.addMouseMotionListener(this.getMouseMotionListener());
        this.items.setOpaque(false);
    }

    public void set(Collection<T> items) {
        DefaultListModel<T> models = new DefaultListModel<T>();
        for (T item : items) {
            models.addElement(item);
        }
        this.items.removeAll();
        this.items.setModel(models);
    }

    private MouseAdapter getMouseAdapter(final Consumer<SlayerTask> onClickHandler) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int index;
                JList list = (JList)mouseEvent.getSource();
                if (mouseEvent.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(mouseEvent) && (index = list.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    SlayerTask selected = (SlayerTask)list.getModel().getElementAt(index);
                    onClickHandler.accept(selected);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                JList list = (JList)mouseEvent.getSource();
                list.clearSelection();
            }
        };
    }

    private MouseMotionListener getMouseMotionListener() {
        return new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                SlayerTask task = (SlayerTask)list.getModel().getElementAt(index);
                list.setSelectedValue(task, false);
            }
        };
    }

    public JList<T> getItems() {
        return this.items;
    }
}

