/*
 * Decompiled with CFR 0.152.
 */
package com.slayerassistant.userinterface;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.IconTextField;

public class SearchBar {
    private final IconTextField searchBar = new IconTextField();

    public SearchBar(Runnable onKeyTypedHandler, Runnable onClearHandler) {
        this.searchBar.addKeyListener(this.getKeyListener(onKeyTypedHandler));
        this.searchBar.addClearListener(() -> {
            onClearHandler.run();
            this.searchBar.setIcon(IconTextField.Icon.SEARCH);
            this.searchBar.setEditable(true);
        });
        this.setSearchBarStyle();
    }

    private KeyListener getKeyListener(final Runnable onKeyTypedHandler) {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                onKeyTypedHandler.run();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
    }

    private void setSearchBarStyle() {
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.setMinimumSize(new Dimension(0, 30));
    }

    public IconTextField getSearchBar() {
        return this.searchBar;
    }
}

