/*
 * Decompiled with CFR 0.152.
 */
package com.slayerassistant.data;

import com.google.gson.Gson;
import com.slayerassistant.data.DataLoader;
import com.slayerassistant.domain.SlayerTask;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlayerDataLoader
implements DataLoader<Collection<SlayerTask>> {
    private static final Logger log = LoggerFactory.getLogger(SlayerDataLoader.class);

    @Override
    public Collection<SlayerTask> load() {
        List<SlayerTask> list;
        String jsonPath = "/data/slayerTasks.json";
        InputStream inputStream = Objects.requireNonNull(this.getClass().getResourceAsStream(jsonPath));
        InputStreamReader reader = new InputStreamReader(inputStream);
        try {
            SlayerTask[] tasks = (SlayerTask[])new Gson().fromJson((Reader)reader, SlayerTask[].class);
            list = Arrays.asList(tasks);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error(String.format("Could not read JSON from %s", this.getClass() + jsonPath), (Throwable)e);
                return null;
            }
        }
        ((Reader)reader).close();
        return list;
    }
}

