/*
 * Decompiled with CFR 0.152.
 */
package com.slayerassistant;

import com.google.inject.Inject;
import com.slayerassistant.SlayerManager;
import com.slayerassistant.data.SlayerDataLoader;
import com.slayerassistant.domain.SlayerTask;
import com.slayerassistant.userinterface.ButtonUrlPanel;
import com.slayerassistant.userinterface.Header;
import com.slayerassistant.userinterface.ScrollableTextArea;
import com.slayerassistant.userinterface.SearchBar;
import com.slayerassistant.userinterface.SelectList;
import com.slayerassistant.userinterface.SlayerTaskRenderer;
import com.slayerassistant.userinterface.Tab;
import com.slayerassistant.userinterface.TabView;
import com.slayerassistant.userinterface.Table;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlayerPluginPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(SlayerPluginPanel.class);
    private final SlayerManager slayerManager;
    private final SelectList<SlayerTask> slayerTasksList;
    private final SearchBar searchBar;
    private final String[] tabImageNamesWithExtensions = new String[]{"compass.png", "inventory.png", "combat.png", "slayer_icon.png", "wiki.png"};
    private final String[] tableHeaders = new String[]{"Attack styles", "Attributes"};

    @Inject
    public SlayerPluginPanel() {
        this.slayerManager = new SlayerManager(new SlayerDataLoader());
        this.slayerTasksList = new SelectList<SlayerTask>(new SlayerTaskRenderer(), this::openTask);
        this.slayerTasksList.set(this.slayerManager.getAllSlayerTasks());
        this.searchBar = new SearchBar(this.handleOnKeyChanged(), this.handleOnClear());
        this.add((Component)this.searchBar.getSearchBar());
        this.setTaskSelectList(this.slayerManager.getAllSlayerTasks());
    }

    public void setTaskSelectList(Collection<SlayerTask> tasks) {
        this.removeComponents(new Component[]{this.searchBar.getSearchBar()});
        this.slayerTasksList.set(tasks);
        JList<SlayerTask> items = this.slayerTasksList.getItems();
        JScrollPane scrollPane = new JScrollPane(items);
        scrollPane.setPreferredSize(new Dimension(0, 200));
        scrollPane.setOpaque(false);
        this.add(scrollPane);
        this.revalidate();
        this.repaint();
    }

    private void openTask(SlayerTask task) {
        this.removeComponents(null);
        this.add(this.createHeader(task.monster));
        this.add(this.createTabView(task).getTabbedPane());
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(e -> {
            this.closeTask();
            this.remove(closeButton);
        });
        this.add(closeButton);
    }

    private void closeTask() {
        this.removeComponents(null);
        this.add((Component)this.searchBar.getSearchBar());
        this.setTaskSelectList(this.slayerManager.getAllSlayerTasks());
    }

    private JPanel createHeader(String monster) {
        ImageIcon imageIcon;
        Font font = new Font("SansSerif", 0, 15);
        String monsterImageName = monster.replace(" ", "_").concat(".png").toLowerCase();
        String fileName = String.format("/images/monsters/%s", monsterImageName);
        try {
            BufferedImage img = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)fileName);
            BufferedImage resizedImg = ImageUtil.resizeImage((BufferedImage)img, (int)(img.getWidth() / 2), (int)(img.getHeight() / 2));
            imageIcon = new ImageIcon(resizedImg);
        }
        catch (NullPointerException e) {
            log.info(String.format("Could not find resource with name: %s", fileName), (Throwable)e);
            return new Header(font, monster, Color.ORANGE, 0).getHeader();
        }
        return new Header(font, monster, Color.ORANGE, imageIcon, 0).getHeader();
    }

    private TabView createTabView(SlayerTask task) {
        TabView tabView = new TabView();
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
        for (String imageNameWithExtension : this.tabImageNamesWithExtensions) {
            BufferedImage image = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)String.format("/images/%s", imageNameWithExtension));
            ImageIcon imageIcon = new ImageIcon(image);
            icons.add(imageIcon);
        }
        String locations = this.convertStringsToLineSeparatedString(task.locations);
        String masters = this.convertStringsToLineSeparatedString(task.slayerMasters);
        String items = this.convertStringsToLineSeparatedString((String[])Arrays.stream(task.itemsRequired).map(i -> i.name).toArray(String[]::new));
        Tab locationTab = new Tab((ImageIcon)icons.get(0), new ScrollableTextArea(locations).getScrollPane());
        Tab itemTab = new Tab((ImageIcon)icons.get(1), new ScrollableTextArea(items).getScrollPane());
        Tab combatTab = new Tab((ImageIcon)icons.get(2), new Table(this.tableHeaders, task.attackStyles, task.attributes).getTable());
        Tab masterTab = new Tab((ImageIcon)icons.get(3), new ScrollableTextArea(masters).getScrollPane());
        Tab wikiTab = new Tab((ImageIcon)icons.get(4), new ButtonUrlPanel(task.wikiUrls).getPanel());
        tabView.addTabs(new Tab[]{locationTab, itemTab, combatTab, masterTab, wikiTab});
        return tabView;
    }

    private String convertStringsToLineSeparatedString(String[] strings) {
        return String.join((CharSequence)System.lineSeparator(), strings);
    }

    private void removeComponents(@Nullable Component[] excludedComponents) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (excludedComponents != null && Arrays.stream(excludedComponents).anyMatch(c -> c == component)) continue;
            this.remove(component);
        }
        this.revalidate();
        this.repaint();
    }

    private Runnable handleOnKeyChanged() {
        return () -> {
            String text = this.searchBar.getSearchBar().getText();
            Collection<SlayerTask> tasks = Objects.equals(text, "") || Objects.equals(text, null) ? this.slayerManager.getAllSlayerTasks() : this.slayerManager.getSlayerTasksByPartialName(text);
            this.setTaskSelectList(tasks);
        };
    }

    private Runnable handleOnClear() {
        return () -> this.setTaskSelectList(this.slayerManager.getAllSlayerTasks());
    }
}

