/*
 * Decompiled with CFR 0.152.
 */
package com.slayerassistant;

import com.slayerassistant.data.SlayerDataLoader;
import com.slayerassistant.domain.SlayerTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlayerManager {
    private static final Logger log = LoggerFactory.getLogger(SlayerManager.class);
    private Collection<SlayerTask> slayerTasks;

    public SlayerManager(SlayerDataLoader dataLoader) {
        try {
            this.slayerTasks = (Collection)Objects.requireNonNull(dataLoader.load());
        }
        catch (NullPointerException e) {
            log.error("Failed to load slayer data", (Throwable)e);
        }
    }

    public Collection<SlayerTask> getAllSlayerTasks() {
        return this.slayerTasks.stream().sorted(Comparator.comparing(s -> s.monster)).collect(Collectors.toCollection(ArrayList::new));
    }

    public Collection<SlayerTask> getSlayerTasksByPartialName(String monster) {
        return this.slayerTasks.stream().filter(slayerTask -> slayerTask.monster.toLowerCase().contains(monster.toLowerCase())).collect(Collectors.toCollection(ArrayList::new));
    }

    public SlayerTask getSlayerTaskByName(String monster) {
        return this.slayerTasks.stream().filter(slayerTask -> Objects.equals(slayerTask.monster.toLowerCase(), monster.toLowerCase())).findFirst().orElse(null);
    }
}

