/*
 * Decompiled with CFR 0.152.
 */
package com.slayerassistant;

import com.slayerassistant.SlayerPluginPanel;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Slayer Assistant")
public class SlayerAssistantPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SlayerAssistantPlugin.class);
    @Inject
    private ClientToolbar clientToolbar;
    private SlayerPluginPanel slayerPanel;
    private NavigationButton navButton;

    protected void startUp() {
        this.slayerPanel = (SlayerPluginPanel)((Object)this.injector.getInstance(SlayerPluginPanel.class));
        this.navButton = this.getNavButton();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    private NavigationButton getNavButton() {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/images/slayer_icon.png");
        }
        catch (NullPointerException e) {
            log.error(String.format("Could not find image resource at %s", ((Object)((Object)this)).getClass() + "/images/slayer_icon.png"), (Throwable)e);
        }
        return NavigationButton.builder().tooltip("Slayer assistant").icon(bufferedImage).priority(10).panel((PluginPanel)this.slayerPanel).build();
    }
}

