/*
 * Decompiled with CFR 0.152.
 */
package com.reverb;

import com.google.inject.Provides;
import com.reverb.reverbconfig;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ReVerb")
public class reverb
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(reverb.class);
    Pattern p = Pattern.compile("[^-a-zA-z:;0-9\\s]");
    @Inject
    private Client client;
    @Inject
    private reverbconfig config;
    String[] forbiddenChanges = new String[]{"Walk here", "Cancel"};
    boolean sentNonAlphaInput = false;
    boolean sentEmptyStringError = false;
    boolean sentBadFormatError = false;
    boolean sentEmptyInputError = false;
    boolean sentFoundForbiddenPhrase = false;
    boolean wellWrittenInput = true;
    boolean sentWellWritten = false;

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded menuEntryAdded) {
        this.wellWrittenInput = true;
        String userInput = this.config.inputString();
        if (this.containsNonAlpha(userInput)) {
            if (!this.sentNonAlphaInput) {
                this.client.addChatMessage(ChatMessageType.PLAYERRELATED, "", "ReVerb only works with English letters, '-' (dash) ':' (colon) or ';' (semicolon)", "ReVerb Plugin:");
                this.sentNonAlphaInput = true;
            }
            this.wellWrittenInput = false;
            this.sentWellWritten = false;
            return;
        }
        this.sentNonAlphaInput = false;
        String[] inputParsedIntoPairs = userInput.split(";");
        if (inputParsedIntoPairs.length == 1 && inputParsedIntoPairs[0].isEmpty()) {
            if (!this.sentEmptyInputError) {
                this.client.addChatMessage(ChatMessageType.PLAYERRELATED, "", "ReVerb found nothing to replace!", "");
                this.sentEmptyInputError = true;
            }
            this.wellWrittenInput = false;
            this.sentWellWritten = false;
            return;
        }
        this.sentEmptyInputError = false;
        for (String parsedPairs : inputParsedIntoPairs) {
            String[] pairStrings = parsedPairs.split(":");
            if (pairStrings.length != 2) {
                if (!this.sentBadFormatError) {
                    this.client.addChatMessage(ChatMessageType.PLAYERRELATED, "", "ReVerb found an invalid pair! make sure to separate pairs with a semicolon (;)!", "");
                    this.sentBadFormatError = true;
                }
                this.wellWrittenInput = false;
                this.sentWellWritten = false;
                continue;
            }
            pairStrings[0] = pairStrings[0].trim();
            pairStrings[1] = pairStrings[1].trim();
            if (pairStrings[0].length() == 0 || pairStrings[1].length() == 0) {
                if (!this.sentEmptyStringError) {
                    this.client.addChatMessage(ChatMessageType.PLAYERRELATED, "", "ReVerb found an empty phrase! There might be a misplaced colon (:) or an incomplete pair somewhere!", "");
                    this.sentEmptyStringError = true;
                }
                this.wellWrittenInput = false;
                this.sentWellWritten = false;
                continue;
            }
            for (String forbiddenPhrase : this.forbiddenChanges) {
                if (!forbiddenPhrase.equals(pairStrings[0])) continue;
                if (!this.sentFoundForbiddenPhrase) {
                    this.client.addChatMessage(ChatMessageType.PLAYERRELATED, "", "ReVerb found '" + forbiddenPhrase + "' as a phrase. This messes with things!", "");
                    this.sentFoundForbiddenPhrase = true;
                }
                this.wellWrittenInput = false;
                this.sentWellWritten = false;
            }
            if (!menuEntryAdded.getOption().equals(pairStrings[0])) continue;
            String color = String.format("%02x%02x%02x", this.config.highlightColor().getRed(), this.config.highlightColor().getGreen(), this.config.highlightColor().getBlue());
            menuEntryAdded.getMenuEntry().setOption("<col=" + color + ">" + pairStrings[1]);
        }
        if (this.wellWrittenInput) {
            this.sentEmptyStringError = false;
            this.sentBadFormatError = false;
            this.sentNonAlphaInput = false;
            this.sentFoundForbiddenPhrase = false;
            if (!this.sentWellWritten) {
                this.client.addChatMessage(ChatMessageType.PLAYERRELATED, "", "ReVerb is working! If something doesn't look right. Make sure capitalizations are correct!", "");
                this.sentWellWritten = true;
            }
        }
    }

    public boolean containsNonAlpha(String name) {
        return this.p.matcher(name).find();
    }

    @Provides
    reverbconfig provideConfig(ConfigManager configManager) {
        return (reverbconfig)configManager.getConfig(reverbconfig.class);
    }
}

