/*
 * Decompiled with CFR 0.152.
 */
package com.runecost;

import com.google.inject.Provides;
import com.runecost.RuneCostConfig;
import com.runecost.RuneCostPanel;
import com.runecost.ShopStorage;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Rune Cost", description="Calculates cost of runes from certain shops in Gielinor")
public class RuneCostPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RuneCostPlugin.class);
    @Inject
    private Client client;
    @Inject
    public RuneCostConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    private RuneCostPanel panel;
    private NavigationButton navButton;
    private final ShopStorage[] shops = new ShopStorage[]{new ShopStorage("Mage Arena", 0.001f, new String[][]{{"Chaos Rune", "90", "250"}, {"Chaos Rune Pack", "9950", "3"}, {"Death Rune", "180", "250"}, {"Law Rune", "240", "250"}, {"Nature Rune", "250", "180"}}), new ShopStorage("Magic Guild", 0.001f, new String[][]{{"Chaos Rune", "90", "250"}, {"Chaos Rune Pack", "9950", "35"}, {"Mind Rune Pack", "40", "330"}, {"Law Rune", "240", "250"}, {"Soul Rune", "300", "250"}, {"Death Rune", "180", "250"}, {"Blood Rune", "400", "250"}, {"Nature Rune", "250", "180"}}), new ShopStorage("Prifddinas", 0.001f, new String[][]{{"Chaos Rune", "90", "250"}, {"Chaos Rune Pack", "9950", "35"}, {"Mind Rune Pack", "40", "330"}, {"Cosmic Rune", "250", "50"}, {"Law Rune", "240", "250"}, {"Death Rune", "180", "250"}, {"Blood Rune", "400", "250"}, {"Cosmic Rune", "50", "250"}, {"Nature Rune", "180", "250"}}), new ShopStorage("Wildy Shop", 0.001f, new String[][]{{"Chaos Rune", "90", "500"}, {"Chaos Rune Pack", "9950", "35"}, {"Mind Rune Pack", "40", "330"}, {"Law Rune", "240", "250"}, {"Death Rune", "180", "500"}, {"Blood Rune", "400", "500"}, {"Nature Rune", "250", "180"}})};

    @Provides
    RuneCostConfig provideConfig(ConfigManager configManager) {
        return (RuneCostConfig)configManager.getConfig(RuneCostConfig.class);
    }

    protected void startUp() throws Exception {
        this.panel = new RuneCostPanel(this, this.config);
        log.info("Loading Image...");
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"icon.png");
        this.navButton = NavigationButton.builder().tooltip("Rune Cost").priority(5).panel((PluginPanel)this.panel).icon(icon).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.panel.getConfirmButton().addActionListener(e -> this.calculateRuneCost());
        this.panel.getShopBox().addActionListener(e -> this.updateShopOptions());
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    private void calculateRuneCost() {
        String selectedItem;
        int itemIndex;
        String shopName = (String)this.panel.getShopBox().getSelectedItem();
        ShopStorage selectedShop = this.getShopByName(shopName);
        if (selectedShop != null && (itemIndex = this.getItemIndex(selectedShop, selectedItem = (String)this.panel.getShopOptions().getSelectedItem())) != -1) {
            int itemCost = Integer.parseInt(selectedShop.shopItems[itemIndex][1]);
            int itemStock = Integer.parseInt(selectedShop.shopItems[itemIndex][2]);
            int buyLimit = Integer.parseInt(this.panel.getBuyPer().getText());
            int amountWanted = Integer.parseInt(this.panel.getTotalWant().getText());
            if (buyLimit > itemStock) {
                this.panel.setResultInfo("You entered too high of a buy per world. The " + shopName + " only has " + itemStock + " in stock");
                return;
            }
            int[] results = this.calculateItem(itemCost, itemStock, selectedShop.getShopCostPer(), amountWanted, buyLimit);
            if (results != null) {
                DecimalFormat df = new DecimalFormat("###,###,###");
                String totalCost = df.format(results[1]);
                String perWorld = df.format(results[0]);
                this.panel.setResultInfo("Results...\n~Total you will spend: " + totalCost + "\n~Total spent per rune: " + results[1] / amountWanted + "\n~GP Spent Per World: " + perWorld);
            } else {
                this.panel.setResultInfo("You entered too high of a buy per world. The " + shopName + " only has " + itemStock + " in stock");
            }
        }
    }

    private ShopStorage getShopByName(String shopName) {
        for (ShopStorage shop : this.shops) {
            if (!shop.getShopName().equals(shopName)) continue;
            return shop;
        }
        return null;
    }

    private int getItemIndex(ShopStorage shop, String itemName) {
        for (int i = 0; i < shop.shopItems.length; ++i) {
            if (!shop.shopItems[i][0].equals(itemName)) continue;
            return i;
        }
        return -1;
    }

    public int[] calculateItem(int itemCost, int itemStock, float costPer, int amountWanted, int buyPer) {
        int[] results = new int[2];
        float nextCost = 0.0f;
        int currentCost = itemCost;
        int totalSpent = 0;
        if (buyPer > itemStock) {
            return null;
        }
        for (int i = 1; i < buyPer + 1; ++i) {
            nextCost = (float)currentCost * (1.0f + costPer * (float)(i - 1));
            totalSpent = (int)((double)totalSpent + Math.floor(nextCost));
        }
        float amountAdd = (float)totalSpent * 0.02f;
        totalSpent = (int)((double)totalSpent + Math.floor(amountAdd));
        int realTotal = (int)((float)amountWanted / (float)buyPer * (float)totalSpent);
        results[0] = totalSpent;
        results[1] = realTotal;
        return results;
    }

    private void updateShopOptions() {
        String shopName = (String)this.panel.getShopBox().getSelectedItem();
        ShopStorage selectedShop = this.getShopByName(shopName);
        if (selectedShop != null) {
            this.panel.setOptions(this.getColumn(selectedShop.shopItems, 0));
        }
    }

    public String[] getColumn(String[][] array, int index) {
        String[] column = new String[array.length];
        for (int i = 0; i < column.length; ++i) {
            column[i] = array[i][index];
        }
        return column;
    }
}

