/*
 * Decompiled with CFR 0.152.
 */
package com.runecost;

import com.runecost.Hover;
import com.runecost.RuneCostConfig;
import com.runecost.RuneCostPlugin;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuneCostPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(RuneCostPanel.class);
    private static final Dimension PREFERRED_SIZE = new Dimension(125, 30);
    private static final Dimension MINIMUM_SIZE = new Dimension(0, 30);
    private final Dimension RESULT_SIZE = new Dimension(220, 100);
    String[] options = new String[]{"Select Shop"};
    String[] shops = new String[]{"Mage Arena", "Magic Guild", "Prifddinas", "Wildy Shop"};
    private final JTextField totalWant = new JTextField("Total Runes");
    private final JTextField buyPer = new JTextField("Buy Per World");
    private final JTextArea resultInfo = new JTextArea(" Waiting for Calculation...");
    private final JComboBox<String> shopOptions = new JComboBox<String>(this.options);
    private final JComboBox<String> shopsBox = new JComboBox<String>(this.shops);
    private final JButton confirmButton = new JButton("Submit");
    private GridBagConstraints c;

    public JTextField getTotalWant() {
        return this.totalWant;
    }

    public void setResultInfo(String result) {
        this.resultInfo.setText(result);
    }

    public JTextField getBuyPer() {
        return this.buyPer;
    }

    public JComboBox<String> getShopOptions() {
        return this.shopOptions;
    }

    public void setOptions(String[] options) {
        this.shopOptions.removeAllItems();
        for (String s : options) {
            this.shopOptions.addItem(s);
        }
    }

    public JButton getConfirmButton() {
        return this.confirmButton;
    }

    @Inject
    public RuneCostPanel(RuneCostPlugin plugin, RuneCostConfig config) {
        super(true);
        this.setBorder(new EmptyBorder(18, 10, 0, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(0, 0, 5, 0);
        this.totalWant.setPreferredSize(PREFERRED_SIZE);
        this.totalWant.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.totalWant.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.resultInfo.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.totalWant.addMouseListener(new Hover("Total Runes"));
        this.add(this.totalWant, this.c);
        ++this.c.gridy;
        this.c.gridy = 0;
        this.c.gridx = 1;
        this.buyPer.setPreferredSize(PREFERRED_SIZE);
        this.buyPer.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.buyPer.addMouseListener(new Hover("Buy Per"));
        this.add(this.buyPer, this.c);
        this.c.gridx = 0;
        ++this.c.gridy;
        this.shopOptions.setSize(400, 400);
        this.add(this.shopOptions, this.c);
        ++this.c.gridy;
        this.c.gridx = 1;
        this.c.gridy = 1;
        this.shopsBox.setSize(200, 200);
        this.shopsBox.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.add(this.shopsBox, this.c);
        ++this.c.gridy;
        this.c.gridx = 0;
        this.c.gridwidth = 2;
        this.confirmButton.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.add(this.confirmButton, this.c);
        ++this.c.gridy;
        this.c.gridx = 0;
        this.c.gridwidth = 2;
        this.c.gridheight = 10;
        this.c.insets = new Insets(20, 0, 50, 0);
        this.resultInfo.setFont(this.resultInfo.getFont().deriveFont(16.0f));
        this.resultInfo.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.resultInfo.setFocusable(false);
        this.resultInfo.setEditable(false);
        this.resultInfo.setLineWrap(true);
        this.resultInfo.setWrapStyleWord(true);
        this.add(this.resultInfo, this.c);
        ++this.c.gridy;
        log.info("Panel Ran");
    }

    private void calculatePrice() {
    }

    public JComboBox<String> getShopBox() {
        return this.shopsBox;
    }
}

