/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes.ui;

import com.notenoughrunes.NotEnoughRunesPlugin;
import com.notenoughrunes.db.H2DataProvider;
import com.notenoughrunes.db.queries.ItemCurrencyQuery;
import com.notenoughrunes.db.queries.ItemProducesQuery;
import com.notenoughrunes.types.NERProductionRecipe;
import com.notenoughrunes.types.NERShop;
import com.notenoughrunes.ui.NERItem;
import com.notenoughrunes.ui.NERPanel;
import com.notenoughrunes.ui.NERRecipePanel;
import com.notenoughrunes.ui.NERShopsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

class NERUsesPanel
extends JPanel {
    private static final ImageIcon SECTION_EXPAND_ICON;
    private static final ImageIcon SECTION_EXPAND_ICON_HOVER;
    private static final ImageIcon SECTION_RETRACT_ICON;
    private static final ImageIcon SECTION_RETRACT_ICON_HOVER;
    static final ImageIcon BACK_ICON;
    static final ImageIcon BACK_ICON_HOVER;
    private final NERItem nerItem;
    private final H2DataProvider dataProvider;
    private final ItemManager itemManager;
    private final ClientThread clientThread;
    private final String useName;
    private final NERPanel mainPanel;

    NERUsesPanel(NERItem nerItem, ItemManager itemManager, H2DataProvider dataProvider, ClientThread clientThread, NERPanel mainPanel) {
        this.nerItem = nerItem;
        this.dataProvider = dataProvider;
        this.itemManager = itemManager;
        this.clientThread = clientThread;
        this.mainPanel = mainPanel;
        this.useName = nerItem.getInfoItem().getName().length() > nerItem.getInfoItem().getGroup().length() ? nerItem.getInfoItem().getName() : nerItem.getInfoItem().getGroup();
        this.setLayout(new BorderLayout());
        dataProvider.executeMany(new ItemProducesQuery(nerItem.getInfoItem().getItemID()), recipes -> dataProvider.executeMany(new ItemCurrencyQuery(this.useName), shops -> SwingUtilities.invokeLater(() -> this.buildPanel((List<NERProductionRecipe>)recipes, (List<NERShop>)shops))));
    }

    private void buildPanel(List<NERProductionRecipe> recipes, List<NERShop> shops) {
        GridBagConstraints containerGbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0);
        JPanel recipeSection = this.createSection(SectionType.RECIPES, recipes, shops);
        JPanel container = new JPanel(new GridBagLayout());
        container.add((Component)recipeSection, containerGbc);
        ++containerGbc.gridy;
        JPanel shopsSection = this.createSection(SectionType.SHOPS, recipes, shops);
        container.add((Component)shopsSection, containerGbc);
        ++containerGbc.gridy;
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setMaximumSize(new Dimension(220, Integer.MAX_VALUE));
        wrapper.add((Component)container, "North");
        JScrollPane scrollWrapper = new JScrollPane(wrapper);
        scrollWrapper.getVerticalScrollBar().setPreferredSize(new Dimension(12, 0));
        scrollWrapper.getVerticalScrollBar().setBorder(new EmptyBorder(0, 5, 0, 0));
        scrollWrapper.setPreferredSize(new Dimension(225, 1000));
        scrollWrapper.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollWrapper, "Center");
    }

    private JPanel createSection(SectionType sectionType, List<NERProductionRecipe> recipes, List<NERShop> shops) {
        ArrayList<JPanel> sectionItems = new ArrayList<JPanel>();
        switch (sectionType) {
            case RECIPES: {
                recipes.forEach(recipe -> sectionItems.add(new NERRecipePanel((NERProductionRecipe)recipe, this.itemManager, this.clientThread, this.mainPanel, this.useName, this.dataProvider)));
                break;
            }
            case SHOPS: {
                if (shops.isEmpty()) break;
                sectionItems.add(new NERShopsPanel(shops, this.nerItem, this.itemManager, this.clientThread, true, this.mainPanel));
            }
        }
        if (sectionItems.isEmpty()) {
            return new JPanel();
        }
        JPanel section = new JPanel();
        section.setLayout(new BoxLayout(section, 1));
        section.setMinimumSize(new Dimension(210, 0));
        section.setMaximumSize(new Dimension(220, 0));
        JPanel sectionHeader = new JPanel();
        sectionHeader.setLayout(new BorderLayout());
        sectionHeader.setMinimumSize(new Dimension(220, 0));
        sectionHeader.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, ColorScheme.MEDIUM_GRAY_COLOR), new EmptyBorder(0, 0, 3, 1)));
        section.add((Component)sectionHeader, "North");
        final JButton sectionToggle = new JButton(SECTION_EXPAND_ICON);
        sectionToggle.setRolloverIcon(SECTION_EXPAND_ICON_HOVER);
        sectionToggle.setPreferredSize(new Dimension(18, 0));
        sectionToggle.setBorder(new EmptyBorder(0, 0, 0, 5));
        sectionToggle.setToolTipText("Expand");
        SwingUtil.removeButtonDecorations((AbstractButton)sectionToggle);
        sectionHeader.add((Component)sectionToggle, "West");
        JLabel sectionName = new JLabel(sectionType.sectionName);
        sectionName.setForeground(ColorScheme.BRAND_ORANGE);
        sectionName.setFont(FontManager.getRunescapeBoldFont());
        sectionName.setToolTipText(sectionType.sectionDesc);
        sectionHeader.add((Component)sectionName, "Center");
        final JPanel sectionContents = new JPanel();
        sectionContents.setLayout((LayoutManager)new DynamicGridLayout(0, 1, 0, 10));
        sectionContents.setMinimumSize(new Dimension(220, 0));
        sectionContents.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, ColorScheme.MEDIUM_GRAY_COLOR), new EmptyBorder(6, 0, 6, 0)));
        sectionContents.setVisible(false);
        section.add((Component)sectionContents, "South");
        MouseAdapter sectionAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NERUsesPanel.this.toggleSection(sectionToggle, sectionContents);
            }
        };
        sectionToggle.addActionListener(actionEvent -> this.toggleSection(sectionToggle, sectionContents));
        sectionName.addMouseListener(sectionAdapter);
        sectionHeader.addMouseListener(sectionAdapter);
        sectionItems.forEach(sectionContents::add);
        return section;
    }

    private void toggleSection(JButton button, JPanel contents) {
        boolean newState = !contents.isVisible();
        contents.setVisible(newState);
        button.setIcon(newState ? SECTION_RETRACT_ICON : SECTION_EXPAND_ICON);
        button.setRolloverIcon(newState ? SECTION_RETRACT_ICON_HOVER : SECTION_EXPAND_ICON_HOVER);
        button.setToolTipText(newState ? "Retract" : "Expand");
        SwingUtilities.invokeLater(contents::revalidate);
    }

    static {
        BufferedImage backIcon = ImageUtil.loadImageResource(NotEnoughRunesPlugin.class, (String)"ui/config_back_icon.png");
        BACK_ICON = new ImageIcon(backIcon);
        BACK_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)backIcon, (int)-100));
        BufferedImage sectionRetractIcon = ImageUtil.loadImageResource(NotEnoughRunesPlugin.class, (String)"ui/arrow_right.png");
        sectionRetractIcon = ImageUtil.luminanceOffset((Image)sectionRetractIcon, (int)-121);
        SECTION_EXPAND_ICON = new ImageIcon(sectionRetractIcon);
        SECTION_EXPAND_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)sectionRetractIcon, (int)-100));
        BufferedImage sectionExpandIcon = ImageUtil.rotateImage((BufferedImage)sectionRetractIcon, (double)1.5707963267948966);
        SECTION_RETRACT_ICON = new ImageIcon(sectionExpandIcon);
        SECTION_RETRACT_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)sectionExpandIcon, (int)-100));
    }

    static enum SectionType {
        RECIPES("Recipes", "Item recipe uses"),
        SHOPS("Shops", "Item shop uses");

        private final String sectionName;
        private final String sectionDesc;

        private SectionType(String sectionName, String sectionDesc) {
            this.sectionName = sectionName;
            this.sectionDesc = sectionDesc;
        }
    }
}

