/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes.ui;

import com.notenoughrunes.types.NERShop;
import com.notenoughrunes.types.NERShopItem;
import com.notenoughrunes.ui.NERItem;
import com.notenoughrunes.ui.NERPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NERShopsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(NERShopsPanel.class);
    private static final Insets NO_INSETS = new Insets(0, 0, 0, 0);

    public NERShopsPanel(List<NERShop> shops, NERItem nerItem, ItemManager itemManager, ClientThread clientThread, boolean isCurrency, NERPanel mainPanel) {
        String useName = nerItem.getInfoItem().getName().length() > nerItem.getInfoItem().getGroup().length() ? nerItem.getInfoItem().getName() : nerItem.getInfoItem().getGroup();
        this.setMaximumSize(new Dimension(220, 80));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BoxLayout(this, 1));
        int row = 0;
        int entries = 0;
        block0: for (NERShop shop : shops) {
            List<NERShopItem> shopItems = shop.getItems();
            for (NERShopItem shopItem : shopItems) {
                if (entries >= 100) break block0;
                JPanel container = new JPanel(new BorderLayout());
                container.setBorder(new EmptyBorder(0, 0, 7, 0));
                JPanel shopPanel = new JPanel(new GridBagLayout());
                shopPanel.setBorder(new EmptyBorder(7, 7, 6, 7));
                shopPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                JLabel shopName = new JLabel();
                shopName.setMaximumSize(new Dimension(0, 20));
                shopName.setPreferredSize(new Dimension(0, 20));
                shopName.setText(shop.getName());
                shopName.setToolTipText(shop.getName());
                if (shop.isMembers()) {
                    shopName.setForeground(new Color(209, 174, 59));
                }
                shopPanel.add((Component)shopName, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 21, 1, new Insets(0, 4, 0, 0), 4, 4));
                int finalRow = row++;
                clientThread.invokeLater(() -> {
                    Object sellPrice = shop.getSellMultiplier() != null ? (isCurrency ? String.valueOf(itemManager.getItemComposition(itemManager.canonicalize(shopItem.getItemID())).getPrice() * (Integer.parseInt(shop.getSellMultiplier()) / 1000)) : String.valueOf(itemManager.getItemComposition(itemManager.canonicalize(nerItem.getInfoItem().getItemID())).getPrice() * Integer.parseInt(shop.getSellMultiplier()) / 1000)) : shopItem.getSellPrice();
                    sellPrice = shopItem.getCurrency().equals("Coins") ? (String)sellPrice + "gp" : (String)sellPrice + " " + shopItem.getCurrency();
                    Object finalSellPrice = sellPrice;
                    SwingUtilities.invokeLater(() -> NERShopsPanel.lambda$new$0(shopPanel, (String)finalSellPrice, finalRow));
                });
                if (isCurrency) {
                    shopPanel.add((Component)new JLabel(shopItem.getName()), new GridBagConstraints(0, row, 2, 1, 0.0, 0.0, 22, 0, NO_INSETS, 4, 4));
                    ++row;
                }
                JLabel location = new JLabel();
                location.setMaximumSize(new Dimension(0, 20));
                location.setPreferredSize(new Dimension(0, 20));
                location.setText(shop.getLocation());
                location.setToolTipText(shop.getLocation());
                shopPanel.add((Component)location, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 21, 1, new Insets(0, 4, 0, 0), 4, 4));
                shopPanel.add((Component)new JLabel("x" + shopItem.getStock()), new GridBagConstraints(1, row++, 1, 1, 0.1, 0.0, 22, 0, NO_INSETS, 4, 4));
                container.add(shopPanel);
                this.add(container);
                ++entries;
            }
        }
    }

    private static /* synthetic */ void lambda$new$0(JPanel shopPanel, String finalSellPrice, int finalRow) {
        shopPanel.add((Component)new JLabel(finalSellPrice), new GridBagConstraints(1, finalRow, 1, 1, 0.1, 0.0, 22, 0, NO_INSETS, 4, 4));
    }
}

