/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes.ui;

import com.google.common.base.Strings;
import com.notenoughrunes.db.H2DataProvider;
import com.notenoughrunes.db.queries.SearchItemsQuery;
import com.notenoughrunes.types.NERInfoItem;
import com.notenoughrunes.ui.NERItem;
import com.notenoughrunes.ui.NERPanel;
import com.notenoughrunes.ui.NERSearchItemPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.AsyncBufferedImage;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NERSearchResultsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(NERSearchResultsPanel.class);
    private static final int MAX_RESULTS = 200;
    private static final String ERROR_PANEL = "ERROR_PANEL";
    private static final String RESULTS_PANEL = "RESULTS_PANEL";
    private final GridBagConstraints constraints = new GridBagConstraints();
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel searchItemsPanel = new JPanel();
    private final JPanel centerPanel = new JPanel(this.cardLayout);
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();
    private List<NERItem> results = new ArrayList<NERItem>();
    private final ClientThread clientThread;
    private final ItemManager itemManager;
    private final H2DataProvider dataProvider;
    private final NERPanel parentPanel;

    NERSearchResultsPanel(ClientThread clientThread, ItemManager itemManager, H2DataProvider dataProvider, NERPanel parentPanel) {
        this.clientThread = clientThread;
        this.itemManager = itemManager;
        this.dataProvider = dataProvider;
        this.parentPanel = parentPanel;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout(5, 5));
        container.setBorder(new EmptyBorder(5, 2, 0, 2));
        container.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.searchItemsPanel.setLayout(new GridBagLayout());
        this.searchItemsPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        wrapper.add((Component)this.searchItemsPanel, "North");
        JScrollPane resultsWrapper = new JScrollPane(wrapper);
        resultsWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        resultsWrapper.getVerticalScrollBar().setPreferredSize(new Dimension(12, 0));
        resultsWrapper.getVerticalScrollBar().setBorder(new EmptyBorder(0, 5, 0, 0));
        resultsWrapper.setVisible(false);
        JPanel errorWrapper = new JPanel(new BorderLayout());
        errorWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        errorWrapper.add((Component)this.errorPanel, "North");
        this.errorPanel.setContent("Not Enough Runes Search", "Here you can search an item by its name to find its sources and uses");
        this.centerPanel.add((Component)resultsWrapper, RESULTS_PANEL);
        this.centerPanel.add((Component)errorWrapper, ERROR_PANEL);
        this.cardLayout.show(this.centerPanel, ERROR_PANEL);
        container.add((Component)this.centerPanel, "Center");
        this.add((Component)container, "Center");
    }

    boolean updateSearch(IconTextField searchBar) {
        String lookup = searchBar.getText();
        if (Strings.isNullOrEmpty((String)lookup)) {
            this.searchItemsPanel.removeAll();
            this.errorPanel.setContent("Not Enough Runes Search", "Here you can search an item by its name to find its sources and uses");
            this.cardLayout.show(this.centerPanel, ERROR_PANEL);
            searchBar.setIcon(IconTextField.Icon.SEARCH);
            SwingUtilities.invokeLater(this.searchItemsPanel::updateUI);
            return false;
        }
        this.searchItemsPanel.removeAll();
        searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        searchBar.setEditable(false);
        searchBar.setIcon(IconTextField.Icon.LOADING);
        return true;
    }

    void itemSearch(IconTextField searchBar) {
        if (!this.updateSearch(searchBar)) {
            return;
        }
        String search = searchBar.getText();
        this.results.clear();
        this.dataProvider.executeMany(new SearchItemsQuery(search), searchResults -> this.clientThread.invokeLater(() -> {
            searchResults.forEach(itemInfo -> {
                AsyncBufferedImage itemImage = this.itemManager.getImage(this.itemManager.canonicalize(itemInfo.getItemID()));
                this.results.add(new NERItem(itemImage, (NERInfoItem)itemInfo));
            });
            if (this.results.isEmpty()) {
                searchBar.setIcon(IconTextField.Icon.ERROR);
                this.errorPanel.setContent("No results found", "No items were found with that name, please try again.");
                this.cardLayout.show(this.centerPanel, ERROR_PANEL);
                searchBar.setEditable(true);
                return;
            }
            this.results = this.results.stream().sorted(this.compareNameAndGroup(search)).collect(Collectors.toList());
            SwingUtilities.invokeLater(this::processResult);
            searchBar.setIcon(IconTextField.Icon.SEARCH);
        }));
    }

    void processResult() {
        this.cardLayout.show(this.centerPanel, RESULTS_PANEL);
        int index = 0;
        if (this.results.isEmpty()) {
            return;
        }
        for (NERItem nerItem : this.results) {
            if (index + 1 > 200) break;
            NERSearchItemPanel panel = new NERSearchItemPanel(nerItem, this.parentPanel);
            if (index++ > 0) {
                JPanel marginWrapper = new JPanel(new BorderLayout());
                marginWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
                marginWrapper.setBorder(new EmptyBorder(5, 0, 0, 0));
                marginWrapper.add((Component)panel, "North");
                this.searchItemsPanel.add((Component)marginWrapper, this.constraints);
            } else {
                this.searchItemsPanel.add((Component)panel, this.constraints);
            }
            this.searchItemsPanel.updateUI();
            ++this.constraints.gridy;
        }
    }

    private Comparator<NERItem> compareNameAndGroup(String itemName) {
        return Comparator.comparing(item -> new LevenshteinDistance().apply((CharSequence)item.getInfoItem().getName(), (CharSequence)itemName)).thenComparing(item -> new LevenshteinDistance().apply((CharSequence)item.getInfoItem().getGroup(), (CharSequence)itemName));
    }
}

