/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes.ui;

import com.notenoughrunes.ui.NERItem;
import com.notenoughrunes.ui.NERPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NERSearchItemPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(NERSearchItemPanel.class);
    private static final Dimension ICON_SIZE = new Dimension(32, 32);

    NERSearchItemPanel(final NERItem item, final NERPanel mainPanel) {
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        this.setLayout(layout);
        this.setToolTipText(item.getInfoItem().getGroup() + (String)(item.getInfoItem().getVersion() != null && !item.getInfoItem().getVersion().isEmpty() ? " - " + item.getInfoItem().getVersion() : ""));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        final Color background = this.getBackground();
        final ArrayList<JPanel> panels = new ArrayList<JPanel>();
        panels.add(this);
        MouseAdapter itemPanelMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                for (JPanel panel : panels) {
                    NERSearchItemPanel.this.matchComponentBackground(panel, ColorScheme.DARK_GRAY_HOVER_COLOR);
                }
                NERSearchItemPanel.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                for (JPanel panel : panels) {
                    NERSearchItemPanel.this.matchComponentBackground(panel, background);
                }
                NERSearchItemPanel.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                mainPanel.displayItem(item);
            }
        };
        this.addMouseListener(itemPanelMouseListener);
        this.setBorder(new EmptyBorder(5, 5, 5, 0));
        JLabel itemIcon = new JLabel();
        itemIcon.setPreferredSize(ICON_SIZE);
        if (item.getIcon() != null) {
            item.getIcon().addTo(itemIcon);
        }
        this.add((Component)itemIcon, "Before");
        JPanel rightPanel = new JPanel(new GridLayout(1, 1));
        panels.add(rightPanel);
        rightPanel.setBackground(background);
        JLabel itemName = new JLabel();
        itemName.setForeground(Color.WHITE);
        itemName.setMaximumSize(new Dimension(0, 0));
        itemName.setPreferredSize(new Dimension(0, 0));
        itemName.setText(item.getInfoItem().getName());
        rightPanel.add(itemName);
        this.add((Component)rightPanel, "Center");
    }

    private void matchComponentBackground(JPanel panel, Color color) {
        panel.setBackground(color);
        for (Component c : panel.getComponents()) {
            c.setBackground(color);
        }
    }
}

