/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes.ui;

import com.notenoughrunes.db.H2DataProvider;
import com.notenoughrunes.db.queries.ItemByIDQuery;
import com.notenoughrunes.types.NERInfoItem;
import com.notenoughrunes.types.NERProductionMaterial;
import com.notenoughrunes.types.NERProductionRecipe;
import com.notenoughrunes.types.NERProductionSkill;
import com.notenoughrunes.ui.NERItem;
import com.notenoughrunes.ui.NERPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NERRecipePanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(NERRecipePanel.class);
    private static final Map<String, BufferedImage> facilityImages = Stream.of("Anvil", "Apothecary", "Banner easel", "Barbarian anvil", "Big compost bin", "Blast furnace", "Brewery", "Clay oven", "Compost bin", "Cooking range", "Cooking range (2018 Easter event)", "Crafting table 1", "Crafting table 2", "Crafting table 3", "Crafting table 4", "Dairy churn", "Dairy cow", "Demon lectern", "Eagle lectern", "Eodan", "Fancy Clothes Store", "Farming patch", "Furnace", "Loom", "Mahogany demon lectern", "Mahogany eagle lectern", "Metal press", "Oak lectern", "Pluming stand", "Pottery wheel", "Sandpit", "Sawmill", "Sbott", "Shield easel", "Singing bowl", "Spinning wheel", "Tannery", "Taxidermist", "Teak demon lectern", "Teak eagle lectern", "Thakkrad Sigmundson", "Water", "Whetstone", "Windmill", "Woodcutting stump", "Workbench").collect(Collectors.toMap(Function.identity(), name -> {
        try {
            return ImageUtil.loadImageResource(NERRecipePanel.class, (String)("recipe_facility_icons/" + name + ".png"));
        }
        catch (Exception e) {
            return new BufferedImage(20, 20, 2);
        }
    }));
    private static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    private final ItemManager itemManager;
    private final ClientThread clientThread;
    private final NERPanel mainPanel;
    private final H2DataProvider dataProvider;

    public NERRecipePanel(NERProductionRecipe recipe, ItemManager itemManager, ClientThread clientThread, NERPanel mainPanel, String useName, H2DataProvider dataProvider) {
        this.itemManager = itemManager;
        this.clientThread = clientThread;
        this.mainPanel = mainPanel;
        this.dataProvider = dataProvider;
        this.setMaximumSize(new Dimension(225, 800));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(7, 7, 6, 7));
        int row = 0;
        if (recipe.getFacilities() != null) {
            JLabel facilityLabel = new JLabel(recipe.getFacilities());
            facilityLabel.setMaximumSize(new Dimension(0, 20));
            facilityLabel.setPreferredSize(new Dimension(0, 20));
            facilityLabel.setHorizontalAlignment(0);
            if (facilityImages.containsKey(recipe.getFacilities())) {
                facilityLabel.setIcon(new ImageIcon(facilityImages.get(recipe.getFacilities())));
            }
            this.add((Component)facilityLabel, new GridBagConstraints(0, row++, 4, 1, 1.0, 0.0, 10, 1, NO_INSETS, 4, 4));
        }
        JPanel skillsPanel = new JPanel(new GridBagLayout());
        skillsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        int skillsRow = 0;
        for (NERProductionSkill nERProductionSkill : recipe.getSkills()) {
            String iconPath = "/skill_icons/" + nERProductionSkill.getName().toLowerCase() + ".png";
            skillsPanel.add((Component)new JLabel(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)iconPath))), new GridBagConstraints(0, skillsRow, 1, 1, 0.0, 0.0, 10, 0, NO_INSETS, 4, 4));
            skillsPanel.add((Component)new JLabel(nERProductionSkill.getName()), new GridBagConstraints(1, skillsRow, 1, 1, 1.0, 0.0, 21, 0, NO_INSETS, 4, 4));
            skillsPanel.add((Component)new JLabel("<html><body style=\"text-align:right\">Lv" + nERProductionSkill.getLevel() + "</body></html>"), new GridBagConstraints(2, skillsRow, 1, 1, 0.2, 0.0, 22, 0, NO_INSETS, 4, 4));
            skillsPanel.add((Component)new JLabel(nERProductionSkill.getExperience() + "xp"), new GridBagConstraints(3, skillsRow++, 1, 1, 0.0, 0.0, 22, 0, NO_INSETS, 4, 4));
        }
        this.add((Component)skillsPanel, new GridBagConstraints(0, row++, 4, 1, 0.0, 0.0, 21, 1, NO_INSETS, 4, 4));
        JLabel materialHeader = new JLabel("Materials");
        this.add((Component)materialHeader, new GridBagConstraints(0, row++, 4, 1, 1.0, 0.0, 10, 0, NO_INSETS, 4, 4));
        if (recipe.getTools() != null) {
            this.addTooltip(materialHeader, "Tools: " + recipe.getTools());
        }
        for (NERProductionMaterial material : recipe.getMaterials()) {
            JPanel materialRow = new JPanel(new GridBagLayout());
            materialRow.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            JLabel materialLabel = new JLabel();
            this.setItemImage(materialLabel, material.getItemID());
            materialLabel.setText(material.getName());
            materialLabel.setToolTipText(material.getName());
            materialLabel.setMaximumSize(new Dimension(0, 30));
            materialLabel.setPreferredSize(new Dimension(0, 30));
            materialRow.add((Component)materialLabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 21, 1, NO_INSETS, 4, 4));
            materialRow.add((Component)new JLabel("x" + material.getQuantity()), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 4, 4));
            this.addMouseAdapter(materialLabel, material.getItemID(), useName);
            this.add((Component)materialRow, new GridBagConstraints(0, row++, 4, 1, 0.0, 0.0, 10, 1, NO_INSETS, 4, 4));
        }
        this.add((Component)new JLabel("Output"), new GridBagConstraints(0, row++, 4, 1, 1.0, 0.0, 10, 0, NO_INSETS, 4, 4));
        JLabel jLabel = new JLabel();
        this.setItemImage(jLabel, recipe.getOutputItemID());
        jLabel.setText(recipe.getOutputItemName());
        jLabel.setToolTipText(recipe.getOutputItemName());
        jLabel.setMaximumSize(new Dimension(0, 20));
        jLabel.setPreferredSize(new Dimension(0, 20));
        this.add((Component)jLabel, new GridBagConstraints(0, row, 3, 1, 1.0, 0.0, 21, 1, NO_INSETS, 4, 4));
        this.addMouseAdapter(jLabel, recipe.getOutputItemID(), useName);
        JLabel quantityLabel = new JLabel("x" + recipe.getOutputQuantity());
        this.add((Component)quantityLabel, new GridBagConstraints(3, row, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 4, 0, 0), 4, 4));
        if (recipe.getOutputQuantityNote() != null) {
            quantityLabel.setText("<html><body style=\"border-bottom: 1px dotted #ffffff\">" + quantityLabel.getText() + "*");
            String tooltipText = recipe.getOutputQuantityNote().replaceAll("[\\[\\]]|<[^>]*>", "");
            quantityLabel.setToolTipText(String.format("<html><p width=\"%d\">%s</p></html>", 200, tooltipText));
        }
    }

    private void setItemImage(JLabel label, int itemId) {
        this.clientThread.invokeLater(() -> {
            AsyncBufferedImage itemImage = this.itemManager.getImage(this.itemManager.canonicalize(itemId));
            SwingUtilities.invokeLater(() -> label.setIcon(new ImageIcon((Image)itemImage)));
        });
    }

    private void displayItem(NERInfoItem itemInfo) {
        this.clientThread.invokeLater(() -> {
            AsyncBufferedImage icon = this.itemManager.getImage(this.itemManager.canonicalize(itemInfo.getItemID()));
            NERItem nerItem = new NERItem(icon, itemInfo);
            SwingUtilities.invokeLater(() -> this.mainPanel.displayItem(nerItem));
        });
    }

    private void addTooltip(JLabel toUnderline, String tooltip) {
        Font f = toUnderline.getFont();
        HashMap attributes = new HashMap(f.getAttributes());
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED);
        toUnderline.setFont(f.deriveFont(attributes));
        toUnderline.setText(toUnderline.getText());
        toUnderline.setToolTipText(tooltip);
    }

    private void addMouseAdapter(JLabel materialLabel, final int itemID, final String useName) {
        materialLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NERRecipePanel.this.dataProvider.executeSingle(new ItemByIDQuery(itemID), itemInfo -> SwingUtilities.invokeLater(() -> {
                    if (itemInfo.getName().equals(useName) || itemInfo.getGroup().equals(useName)) {
                        return;
                    }
                    NERRecipePanel.this.displayItem((NERInfoItem)itemInfo);
                }));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                NERRecipePanel.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NERRecipePanel.this.setCursor(new Cursor(0));
            }
        });
    }
}

