/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes.ui;

import com.google.common.base.Strings;
import com.notenoughrunes.NotEnoughRunesPlugin;
import com.notenoughrunes.db.H2DataProvider;
import com.notenoughrunes.db.queries.ItemByIDQuery;
import com.notenoughrunes.types.NERInfoItem;
import com.notenoughrunes.ui.NERItem;
import com.notenoughrunes.ui.NERItemPanel;
import com.notenoughrunes.ui.NERSearchResultsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NERPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(NERPanel.class);
    private final IconTextField searchBar = new IconTextField();
    private final ClientThread clientThread;
    private final ItemManager itemManager;
    private final H2DataProvider dataProvider;
    public static final int MAX_ENTRIES = 100;
    private NERItemPanel itemPanel;
    private JPanel currentPanel;
    private final NERSearchResultsPanel searchResultsPanel;

    @Inject
    private NERPanel(NotEnoughRunesPlugin plugin, ClientThread clientThread, ItemManager itemManager, H2DataProvider dataProvider, ScheduledExecutorService executor) {
        super(false);
        this.searchResultsPanel = new NERSearchResultsPanel(clientThread, itemManager, dataProvider, this);
        this.clientThread = clientThread;
        this.itemManager = itemManager;
        this.dataProvider = dataProvider;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(100, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.addActionListener(e -> executor.execute(this::itemSearch));
        this.searchBar.addClearListener(this::updateSearch);
        this.add((Component)this.searchBar, "North");
        this.add(this.searchResultsPanel);
        this.currentPanel = this.searchResultsPanel;
    }

    private void updateSearch() {
        this.searchResultsPanel.updateSearch(this.searchBar);
    }

    private void itemSearch() {
        if (Strings.isNullOrEmpty((String)this.searchBar.getText())) {
            this.updateSearch();
            return;
        }
        if (this.itemPanel != null) {
            this.remove(this.itemPanel);
            SwingUtilities.invokeLater(() -> {
                this.updateUI();
                this.itemPanel = null;
            });
        }
        this.currentPanel = this.searchResultsPanel;
        this.add(this.searchResultsPanel);
        this.searchResultsPanel.itemSearch(this.searchBar);
        this.searchBar.setEditable(true);
    }

    void displayItem(NERItem item) {
        this.itemPanel = new NERItemPanel(item, this.itemManager, this.dataProvider, this.clientThread, this);
        this.remove(this.currentPanel);
        this.currentPanel = this.itemPanel;
        this.add(this.itemPanel, "Center");
        this.updateUI();
    }

    public void displayItemById(int itemId) {
        this.dataProvider.executeSingle(new ItemByIDQuery(itemId), this::getNerItem);
    }

    void getNerItem(NERInfoItem itemInfo) {
        this.clientThread.invokeLater(() -> {
            AsyncBufferedImage icon = this.itemManager.getImage(this.itemManager.canonicalize(itemInfo.getItemID()));
            NERItem nerItem = new NERItem(icon, itemInfo);
            SwingUtilities.invokeLater(() -> this.displayItem(nerItem));
        });
    }

    public NERSearchResultsPanel getSearchResultsPanel() {
        return this.searchResultsPanel;
    }
}

