/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes.ui;

import com.notenoughrunes.db.H2DataProvider;
import com.notenoughrunes.types.NERInfoItem;
import com.notenoughrunes.ui.NERItem;
import com.notenoughrunes.ui.NERPanel;
import com.notenoughrunes.ui.NERSourcesPanel;
import com.notenoughrunes.ui.NERUsesPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NERItemPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(NERItemPanel.class);
    private static final Dimension ICON_SIZE = new Dimension(38, 32);
    private static final BufferedImage WIKI_ICON_DESELECTED = ImageUtil.loadImageResource(NERItemPanel.class, (String)"wiki_icon_deselected.png");
    private static final BufferedImage WIKI_ICON_SELECTED = ImageUtil.loadImageResource(NERItemPanel.class, (String)"wiki_icon_selected.png");
    private static final BufferedImage GE_ICON = ImageUtil.loadImageResource(NERItemPanel.class, (String)"ge_icon.png");
    private static final BufferedImage HA_ICON = ImageUtil.loadImageResource(NERItemPanel.class, (String)"ha_icon.png");
    private final NERSourcesPanel sourcesPanel;
    private final NERUsesPanel usesPanel;
    public NERItem item;
    private final ClientThread clientThread;
    private final ItemManager itemManager;

    NERItemPanel(final NERItem item, ItemManager itemManager, H2DataProvider dataProvider, ClientThread clientThread, NERPanel mainPanel) {
        this.item = item;
        this.sourcesPanel = new NERSourcesPanel(item, itemManager, dataProvider, clientThread, mainPanel);
        this.usesPanel = new NERUsesPanel(item, itemManager, dataProvider, clientThread, mainPanel);
        this.clientThread = clientThread;
        this.itemManager = itemManager;
        log.debug("Creating item panel: " + item.getInfoItem().getName());
        String useName = item.getInfoItem().getName().length() > item.getInfoItem().getGroup().length() ? item.getInfoItem().getName() : item.getInfoItem().getGroup();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JLabel itemIcon = new JLabel(new ImageIcon((Image)item.getIcon()), 4);
        itemIcon.setPreferredSize(ICON_SIZE);
        final JLabel wikiIcon = new JLabel(new ImageIcon(WIKI_ICON_DESELECTED));
        wikiIcon.setPreferredSize(new Dimension(40, 20));
        wikiIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                LinkBrowser.browse((String)item.getInfoItem().getUrl());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                wikiIcon.setIcon(new ImageIcon(WIKI_ICON_SELECTED));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                wikiIcon.setIcon(new ImageIcon(WIKI_ICON_DESELECTED));
            }
        });
        JPanel itemInfoRight = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        JLabel itemNameLabel = new JLabel();
        itemNameLabel.setForeground(ColorScheme.BRAND_ORANGE);
        itemNameLabel.setHorizontalAlignment(0);
        Font nameFont = FontManager.getRunescapeBoldFont();
        HashMap attributes = new HashMap(nameFont.getAttributes());
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        itemNameLabel.setFont(FontManager.getRunescapeBoldFont().deriveFont(attributes).deriveFont(20.0f));
        itemNameLabel.setText(useName);
        itemInfoRight.add((Component)itemNameLabel, gbc);
        ++gbc.gridy;
        JLabel itemDesc = new JLabel();
        itemDesc.setForeground(Color.WHITE);
        itemDesc.setFont(FontManager.getRunescapeSmallFont());
        itemDesc.setHorizontalAlignment(0);
        itemDesc.setVerticalAlignment(1);
        itemDesc.setText(String.format("<html><body style=\"text-justify: none; text-align: center; overflow: clip;\">%s</body></html>", item.getInfoItem().getExamineText()));
        itemInfoRight.add((Component)itemDesc, gbc);
        ++gbc.gridy;
        itemInfoRight.setBackground(this.getBackground());
        JLabel geIcon = new JLabel(new ImageIcon(GE_ICON));
        geIcon.setPreferredSize(new Dimension(15, 15));
        JLabel geLabel = new JLabel("GE Price:");
        geLabel.setForeground(Color.WHITE);
        geLabel.setHorizontalAlignment(2);
        JLabel gePriceLabel = new JLabel();
        gePriceLabel.setForeground(Color.WHITE);
        gePriceLabel.setHorizontalAlignment(4);
        JPanel itemGEPriceInfo = new JPanel(new GridBagLayout());
        itemGEPriceInfo.setVisible(false);
        itemGEPriceInfo.add((Component)geIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 3, 0, 0), 4, 4));
        itemGEPriceInfo.add((Component)geLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 4, 4));
        itemGEPriceInfo.add((Component)gePriceLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 22, 1, new Insets(0, 0, 0, 0), 4, 4));
        JLabel haIcon = new JLabel(new ImageIcon(HA_ICON));
        haIcon.setPreferredSize(new Dimension(20, 18));
        JLabel haLabel = new JLabel("High Alch:");
        haLabel.setForeground(Color.WHITE);
        haLabel.setHorizontalAlignment(2);
        JLabel haPriceLabel = new JLabel();
        haPriceLabel.setForeground(Color.WHITE);
        haPriceLabel.setHorizontalAlignment(4);
        JPanel itemHAPriceInfo = new JPanel(new GridBagLayout());
        itemHAPriceInfo.setVisible(false);
        itemHAPriceInfo.add((Component)haIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 4, 4));
        itemHAPriceInfo.add((Component)haLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 4, 4));
        itemHAPriceInfo.add((Component)haPriceLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 22, 1, new Insets(0, 0, 0, 0), 4, 4));
        this.setItemPrices(item.getInfoItem(), itemGEPriceInfo, gePriceLabel, itemHAPriceInfo, haPriceLabel);
        JPanel itemInfo = new JPanel();
        itemInfo.setLayout(new GridBagLayout());
        itemInfo.setBorder(new EmptyBorder(5, 5, 0, 0));
        itemInfo.add((Component)itemIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 4, 4));
        itemInfo.add((Component)wikiIcon, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 4, 10));
        itemInfo.add((Component)itemInfoRight, new GridBagConstraints(1, 0, 1, 2, 1.0, 0.0, 22, 1, new Insets(0, 0, 0, 0), 4, 4));
        itemInfo.add((Component)itemGEPriceInfo, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 21, 1, new Insets(0, 20, 0, 20), 4, 4));
        itemInfo.add((Component)itemHAPriceInfo, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 21, 1, new Insets(0, 20, 0, 20), 4, 4));
        JPanel tabDisplay = new JPanel();
        MaterialTabGroup tabGroup = new MaterialTabGroup(tabDisplay);
        MaterialTab sourcesTab = new MaterialTab("Sources", tabGroup, (JComponent)this.sourcesPanel);
        MaterialTab usesTab = new MaterialTab("Uses", tabGroup, (JComponent)this.usesPanel);
        tabGroup.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        tabGroup.addTab(sourcesTab);
        tabGroup.addTab(usesTab);
        tabGroup.select(sourcesTab);
        JPanel tabContainer = new JPanel();
        tabContainer.setLayout(new BorderLayout());
        tabContainer.add((Component)tabGroup, "North");
        tabContainer.add((Component)tabDisplay, "Center");
        this.add((Component)itemInfo, "North");
        this.add((Component)tabContainer, "Center");
    }

    void setItemPrices(NERInfoItem infoItem, JPanel geRow, JLabel geLabel, JPanel haRow, JLabel haLabel) {
        this.clientThread.invokeLater(() -> {
            int gePrice = this.itemManager.getItemPrice(infoItem.getItemID());
            int haPrice = this.itemManager.getItemComposition(infoItem.getItemID()).getHaPrice();
            SwingUtilities.invokeLater(() -> {
                if (gePrice > 0) {
                    geLabel.setText(QuantityFormatter.formatNumber((long)gePrice) + "gp");
                    geRow.setVisible(true);
                }
                if (haPrice > 0) {
                    haLabel.setText(QuantityFormatter.formatNumber((long)haPrice) + "gp");
                    haRow.setVisible(true);
                }
            });
        });
    }

    public NERSourcesPanel getSourcesPanel() {
        return this.sourcesPanel;
    }

    public NERUsesPanel getUsesPanel() {
        return this.usesPanel;
    }
}

