/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes.ui;

import com.notenoughrunes.RarityParser;
import com.notenoughrunes.types.NERDropItem;
import com.notenoughrunes.types.NERDropSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NERDropsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(NERDropsPanel.class);
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("#.##%");
    private static final String[] dropTypes = new String[]{"agility", "combat", "farming", "firemaking", "fishing", "hunter", "mining", "reward", "smithing", "woodcutting", "thieving", ""};
    private static final Map<String, BufferedImage> dropTypeImages = Stream.of(dropTypes).collect(Collectors.toMap(Function.identity(), name -> {
        try {
            if (name.equals("")) {
                return ImageUtil.loadImageResource(NERDropsPanel.class, (String)"drop_source_types/combat.png");
            }
            return ImageUtil.loadImageResource(NERDropsPanel.class, (String)("drop_source_types/" + name + ".png"));
        }
        catch (Exception e) {
            return new BufferedImage(20, 20, 2);
        }
    }));

    public NERDropsPanel(NERDropItem dropItem) {
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BoxLayout(this, 1));
        dropItem.getDropSources().stream().sorted(Comparator.comparing(RarityParser::calculateRarity, Comparator.reverseOrder())).limit(100L).forEachOrdered(dropSource -> {
            JPanel container = new JPanel(new BorderLayout());
            container.setBorder(new EmptyBorder(0, 0, 7, 0));
            JPanel dropPanel = new JPanel(new GridBagLayout());
            dropPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            dropPanel.setBorder(new EmptyBorder(7, 7, 6, 7));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.anchor = 21;
            gbc.gridwidth = 3;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 4, 0, 4);
            JLabel dropName = new JLabel(dropSource.getSource());
            dropName.setPreferredSize(new Dimension(0, 20));
            dropPanel.add((Component)dropName, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            dropPanel.add((Component)new JLabel(this.buildQuantityString((NERDropSource)dropSource)), gbc);
            JLabel dropType = new JLabel(dropSource.getDropLevel() + " " + dropSource.getDropType(), 0);
            ImageIcon dropTypeIcon = new ImageIcon(new BufferedImage(1, 20, 2));
            if (Arrays.asList(dropTypes).contains(dropSource.getDropType())) {
                dropTypeIcon = new ImageIcon(dropTypeImages.get(dropSource.getDropType()));
                dropType.setText(dropSource.getDropLevel());
            }
            dropType.setIcon(dropTypeIcon);
            dropType.setToolTipText(dropSource.getDropLevel());
            dropType.setPreferredSize(new Dimension(20, 20));
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 10;
            gbc.fill = 1;
            dropPanel.add((Component)dropType, gbc);
            JLabel rarityLabel = new JLabel(dropSource.getRarity());
            if (dropSource.getRarity().contains("/")) {
                this.addTooltip(rarityLabel, PERCENT_FORMAT.format(RarityParser.calculateRarity(dropSource)));
            }
            gbc.gridx = 2;
            gbc.anchor = 22;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            dropPanel.add((Component)rarityLabel, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 3;
            gbc.anchor = 10;
            gbc.fill = 1;
            gbc.insets = new Insets(4, 0, 4, 0);
            container.add(dropPanel);
            this.add(container);
        });
    }

    private String buildQuantityString(NERDropSource dropSource) {
        if (dropSource.getQuantityLow() == dropSource.getQuantityHigh()) {
            return "x" + dropSource.getQuantityLow();
        }
        return "x" + dropSource.getQuantityLow() + "-" + dropSource.getQuantityHigh();
    }

    private void addTooltip(JLabel toUnderline, String tooltip) {
        Font f = toUnderline.getFont();
        HashMap attributes = new HashMap(f.getAttributes());
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED);
        toUnderline.setFont(f.deriveFont(attributes));
        toUnderline.setText(toUnderline.getText());
        toUnderline.setToolTipText(tooltip);
    }
}

