/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes.db.queries;

import com.notenoughrunes.db.queries.ModeledQuery;
import com.notenoughrunes.types.NERSpawnItem;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ItemSpawnQuery
extends ModeledQuery<NERSpawnItem> {
    private final String itemName;
    private final String groupName;

    @Override
    public String getSql() {
        return "SELECT IG.NAME AS ITEM_GROUP_NAME, SI.* FROM ITEM_GROUPS IG JOIN SPAWN_ITEMS SI ON IG.ID = SI.GROUP_ID WHERE SI.NAME = ?\tAND IG.NAME = ?";
    }

    @Override
    public void setParams(PreparedStatement ps) throws SQLException {
        ps.setString(1, this.itemName);
        ps.setString(2, this.groupName);
    }

    @Override
    public NERSpawnItem convertRow(ResultSet rs) throws SQLException {
        try {
            NERSpawnItem nERSpawnItem = new NERSpawnItem(rs.getString("ITEM_GROUP_NAME"), rs.getString("NAME"), rs.getString("COORDS"), rs.getString("LOCATION"), rs.getBoolean("IS_MEMBERS"));
            return nERSpawnItem;
        }
        finally {
            rs.next();
        }
    }

    public ItemSpawnQuery(String itemName, String groupName) {
        this.itemName = itemName;
        this.groupName = groupName;
    }
}

