/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes.db;

import com.google.common.hash.Funnels;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import com.notenoughrunes.NotEnoughRunesPlugin;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class H2DbFetcher {
    private static final Logger log = LoggerFactory.getLogger(H2DbFetcher.class);
    private static final String dbFileName = "data.sqlite";
    private static final String remoteUrl = "https://raw.githubusercontent.com/Hannah-GBS/runelite-wiki-scraper/wiki-data/output/data.sqlite";
    public static final File dbFile = new File(NotEnoughRunesPlugin.NER_DATA_DIR, "data.sqlite");
    private final OkHttpClient httpClient;

    public void fetch(Runnable callback) {
        this.downloadDbChecksum(callback);
    }

    private void downloadDbChecksum(final Runnable callback) {
        Request req = new Request.Builder().get().url("https://raw.githubusercontent.com/Hannah-GBS/runelite-wiki-scraper/wiki-data/output/data.sqlite.sha256").build();
        this.httpClient.newCall(req).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.error("Failed to download remote checksum for database file");
            }

            public void onResponse(Call call, Response response) throws IOException {
                int n;
                assert (response.body() != null);
                InputStream remoteBytes = response.body().byteStream();
                ByteArrayOutputStream into = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while (0 < (n = remoteBytes.read(buf))) {
                    into.write(buf, 0, n);
                }
                into.close();
                String checksum = into.toString(StandardCharsets.UTF_8).trim();
                if (!dbFile.exists() || !H2DbFetcher.this.checksumMatches(checksum)) {
                    log.debug("Missing db or checksum mismatch. Downloading db");
                    H2DbFetcher.this.downloadRemoteDb(callback);
                } else {
                    callback.run();
                }
            }
        });
    }

    private void downloadRemoteDb(final Runnable callback) {
        Request req = new Request.Builder().get().url(remoteUrl).build();
        this.httpClient.newCall(req).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.error("Failed to download remote database file");
            }

            public void onResponse(Call call, Response response) throws IOException {
                assert (response.body() != null);
                InputStream remoteBytes = response.body().byteStream();
                try (FileOutputStream fos = new FileOutputStream(dbFile);){
                    remoteBytes.transferTo(fos);
                }
                callback.run();
            }
        });
    }

    private boolean checksumMatches(String remote) throws IOException {
        boolean matches;
        if (dbFile.exists()) {
            FileInputStream is = new FileInputStream(dbFile);
            Hasher hasher = Hashing.sha256().newHasher();
            ByteStreams.copy((InputStream)is, (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
            String hash = hasher.hash().toString();
            matches = hash.equals(remote);
        } else {
            matches = false;
        }
        return matches;
    }

    @Inject
    public H2DbFetcher(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

