/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes.db;

import com.google.common.base.Stopwatch;
import com.notenoughrunes.db.H2DbFetcher;
import com.notenoughrunes.db.queries.ModeledQuery;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class H2DataProvider
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(H2DataProvider.class);
    private static final ExecutorService DB_THREAD = Executors.newSingleThreadExecutor();
    private final H2DbFetcher dbFetcher;
    private Connection db;
    private boolean initialized = false;

    public void init() {
        this.initialized = false;
        this.dbFetcher.fetch(() -> DB_THREAD.submit(() -> {
            try {
                Class.forName("org.sqlite.JDBC");
                String dbPath = H2DbFetcher.dbFile.getAbsolutePath();
                log.debug("Creating db connection to {}", (Object)dbPath);
                this.db = DriverManager.getConnection(H2DataProvider.buildConnectionString(dbPath));
            }
            catch (ClassNotFoundException e) {
                log.error("Failed to load SQLite JDBC driver class", (Throwable)e);
            }
            catch (SQLException e) {
                log.error("Failed to open connection to database file", (Throwable)e);
            }
            this.initialized = true;
        }));
    }

    @Override
    public void close() throws Exception {
        this.initialized = false;
        this.db.close();
    }

    private static String buildConnectionString(String fileName) {
        return "jdbc:sqlite:" + fileName;
    }

    public <T> void executeSingle(ModeledQuery<T> query, Consumer<T> callback) {
        this.executeMany(query, res -> callback.accept(res.isEmpty() ? null : (Object)res.get(0)));
    }

    public <T> void executeMany(ModeledQuery<T> query, Consumer<List<T>> callback) {
        if (!this.initialized) {
            callback.accept(Collections.emptyList());
        }
        DB_THREAD.submit(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            try (PreparedStatement ps = this.createStatement(query.getSql());){
                query.setParams(ps);
                try (ResultSet rs = ps.executeQuery();){
                    ArrayList res = new ArrayList();
                    if (rs.next()) {
                        while (!rs.isAfterLast()) {
                            res.add(query.convertRow(rs));
                        }
                    }
                    callback.accept(res);
                }
            }
            catch (Exception e) {
                log.warn("Query failed in wrapMany", (Throwable)e);
                callback.accept(Collections.emptyList());
            }
            finally {
                log.debug("[{}\u03bcs] Query {}", (Object)sw.elapsed(TimeUnit.MICROSECONDS), (Object)query.getSql());
            }
        });
    }

    private PreparedStatement createStatement(String sql) throws SQLException {
        if (!this.initialized) {
            throw new IllegalStateException("Cannot createStatement on a closed connection");
        }
        return this.db.prepareStatement(sql, 1003, 1007);
    }

    @Inject
    public H2DataProvider(H2DbFetcher dbFetcher) {
        this.dbFetcher = dbFetcher;
    }
}

