/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes;

import com.google.common.collect.ImmutableMap;
import com.notenoughrunes.types.NERDropSource;
import java.util.Map;

public final class RarityParser {
    private static final Map<String, Double> PRESET_RARITY_NAMES = ImmutableMap.builder().put((Object)"Always", (Object)1.0).put((Object)"Common", (Object)0.0625).put((Object)"Uncommon", (Object)0.015625).put((Object)"Rare", (Object)0.00390625).put((Object)"Very rare", (Object)9.765625E-4).put((Object)"Random", (Object)2.44140625E-4).put((Object)"Varies", (Object)2.44140625E-4).build();

    public static double calculateRarity(NERDropSource dropSource) {
        return RarityParser.calculateRarity(dropSource.getRarity());
    }

    public static double calculateRarity(String rarityString) {
        if (PRESET_RARITY_NAMES.containsKey(rarityString)) {
            return PRESET_RARITY_NAMES.get(rarityString);
        }
        try {
            String[] fractionComponents = rarityString.split("/");
            return Double.parseDouble(fractionComponents[0].trim().replace(",", "")) / Double.parseDouble(fractionComponents[1].trim().replace(",", ""));
        }
        catch (ArithmeticException | ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return 1.52587890625E-5;
        }
    }

    private RarityParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

