/*
 * Decompiled with CFR 0.152.
 */
package com.notenoughrunes;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.notenoughrunes.NotEnoughRunesConfig;
import com.notenoughrunes.config.MenuLookupMode;
import com.notenoughrunes.db.H2DataProvider;
import com.notenoughrunes.ui.NERPanel;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Not Enough Runes", description="Shows wiki-sourced information where items can be found and what they're used for", tags={"recipe", "crafting", "sources", "Uses", "wiki", "ner"})
public class NotEnoughRunesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NotEnoughRunesPlugin.class);
    public static final File NER_DATA_DIR = new File(RuneLite.RUNELITE_DIR, "not-enough-runes");
    @Inject
    private Client client;
    @Inject
    private NotEnoughRunesConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Gson gson;
    @Inject
    private H2DataProvider dataProvider;
    private NavigationButton navButton;
    private NERPanel nerPanel;

    protected void startUp() throws Exception {
        if (!NER_DATA_DIR.exists()) {
            NER_DATA_DIR.mkdirs();
            this.dataProvider.init();
        } else {
            this.dataProvider.init();
        }
        this.nerPanel = (NERPanel)((Object)this.injector.getInstance(NERPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"icon.png");
        this.navButton = NavigationButton.builder().tooltip("Not Enough Runes").icon(icon).priority(5).panel((PluginPanel)this.nerPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.nerPanel = null;
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        MenuEntry[] entries = event.getMenuEntries();
        for (int idx = entries.length - 1; idx >= 0; --idx) {
            boolean shouldAddBank;
            MenuEntry entry = entries[idx];
            Widget w = entry.getWidget();
            boolean shouldAddInv = !(w == null || WidgetInfo.TO_GROUP((int)w.getId()) != 149 && WidgetInfo.TO_GROUP((int)w.getId()) != 15 || this.config.invLookupMode() == MenuLookupMode.DISABLED || this.config.invLookupMode() == MenuLookupMode.SHIFT && !this.client.isKeyPressed(81));
            boolean bl = shouldAddBank = w != null && WidgetInfo.TO_GROUP((int)w.getId()) == 12 && this.config.bankLookupMode() != MenuLookupMode.DISABLED && (this.config.bankLookupMode() != MenuLookupMode.SHIFT || this.client.isKeyPressed(81));
            if (w == null || !shouldAddInv && !shouldAddBank || !"Examine".equals(entry.getOption()) || entry.getIdentifier() != 10) continue;
            int itemId = w.getItemId();
            this.client.createMenuEntry(idx).setOption("NER Lookup").setTarget(entry.getTarget()).setType(MenuAction.RUNELITE).onClick(e -> {
                this.nerPanel.displayItemById(itemId);
                if (!this.navButton.isSelected()) {
                    this.navButton.getOnSelect().run();
                }
            });
        }
    }

    @Provides
    NotEnoughRunesConfig provideConfig(ConfigManager configManager) {
        return (NotEnoughRunesConfig)configManager.getConfig(NotEnoughRunesConfig.class);
    }

    NavigationButton getNavButton() {
        return this.navButton;
    }

    NERPanel getNerPanel() {
        return this.nerPanel;
    }

    void setNerPanel(NERPanel nerPanel) {
        this.nerPanel = nerPanel;
    }
}

