/*
 * Decompiled with CFR 0.152.
 */
package com.cworldender;

import com.cworldender.BalanceCounter;
import com.cworldender.CoinType;
import com.cworldender.PersonalCurrencyTrackerConfig;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.StatChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Personal Currency Tracker")
public class PersonalCurrencyTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PersonalCurrencyTrackerPlugin.class);
    private static final File CUSTOM_COIN_IMAGE = new File(RuneLite.RUNELITE_DIR, "coin.png");
    private boolean notificationStarted;
    private HashMap<String, Integer> npcRewardsMap;
    private final Set<Actor> taggedActors = new HashSet<Actor>();
    private HashMap<Skill, Integer> skillXPs = new HashMap();
    private int ticksSinceLogin = 0;
    @Inject
    private Client client;
    @Inject
    private PersonalCurrencyTrackerConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    private BalanceCounter balanceBox;
    @Inject
    private ItemManager itemManager;

    protected void startUp() {
        log.info("Personal Currency Tracker started!");
        this.createInfoBox();
        this.updateNPCKillRewardMap(this.config.npcKillRewards());
    }

    protected void shutDown() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.balanceBox);
        this.notificationStarted = false;
        this.taggedActors.clear();
        log.info("Personal Currency Tracker stopped!");
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("personalcurrencytracker")) {
            this.updateInfobox(this.config.balance());
            this.updateNPCKillRewardMap(this.config.npcKillRewards());
        }
    }

    private void incrementBalance(int amount) {
        this.config.setBalance(this.config.balance() + amount);
    }

    private void setBalance(int amount) {
        this.config.setBalance(amount);
    }

    @Subscribe
    protected void onChatMessage(ChatMessage message) {
        if (message.getType() != ChatMessageType.GAMEMESSAGE && message.getType() != ChatMessageType.SPAM && message.getType() != ChatMessageType.TRADE && message.getType() != ChatMessageType.FRIENDSCHATNOTIFICATION) {
            return;
        }
        String msg = message.getMessage();
        if (this.config.useCaskets() && msg.contains("You have completed") && msg.contains("Treasure")) {
            Pattern NUMBER_PATTERN = Pattern.compile("([0-9]+)");
            Matcher m = NUMBER_PATTERN.matcher(Text.removeTags((String)msg));
            if (m.find()) {
                String clueType = msg.substring(msg.lastIndexOf(m.group()) + m.group().length() + 1, msg.indexOf("Treasure") - 1);
                switch (clueType.toLowerCase()) {
                    case "beginner": {
                        this.incrementBalance(this.config.beginnerReward());
                        break;
                    }
                    case "easy": {
                        this.incrementBalance(this.config.easyReward());
                        break;
                    }
                    case "medium": {
                        this.incrementBalance(this.config.mediumReward());
                        break;
                    }
                    case "hard": {
                        this.incrementBalance(this.config.hardReward());
                        break;
                    }
                    case "elite": {
                        this.incrementBalance(this.config.eliteReward());
                        break;
                    }
                    case "master": {
                        this.incrementBalance(this.config.masterReward());
                        break;
                    }
                }
            } else if (msg.startsWith("New item added to your collection log:") && this.config.collLogReward() != 0) {
                this.incrementBalance(this.config.collLogReward());
            }
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        switch (scriptPreFired.getScriptId()) {
            case 3346: {
                this.notificationStarted = true;
                break;
            }
            case 3347: {
                if (!this.notificationStarted) {
                    return;
                }
                String topText = this.client.getVarcStrValue(387);
                if (topText.equalsIgnoreCase("Collection log") && this.config.collLogReward() != 0) {
                    this.incrementBalance(this.config.collLogReward());
                }
                this.notificationStarted = false;
            }
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        Player player;
        Actor actor = actorDeath.getActor();
        if (actor instanceof Player && (player = (Player)actor) == this.client.getLocalPlayer()) {
            this.incrementBalance(this.config.deathReward());
        }
        if (this.taggedActors.contains(actor)) {
            this.incrementBalance(this.npcRewardsMap.getOrDefault(Objects.requireNonNull(actor.getName()).toLowerCase(), 0));
            this.taggedActors.remove(actor);
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        Actor actor = hitsplatApplied.getActor();
        if (actor != null && hitsplatApplied.getHitsplat().isMine() && this.npcRewardsMap.containsKey(actor.getName().toLowerCase())) {
            this.taggedActors.add((Actor)((NPC)actor));
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        this.taggedActors.remove(npcDespawned.getNpc());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case HOPPING: 
            case LOGGING_IN: {
                this.taggedActors.clear();
                this.ticksSinceLogin = 0;
                this.skillXPs.clear();
            }
        }
    }

    private void updateInfobox(int newCount) {
        if (this.balanceBox != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.balanceBox);
        }
        if (this.config.infopanel()) {
            this.createInfoBox();
        }
    }

    private void createInfoBox() {
        if (this.config.infopanel()) {
            BufferedImage image = this.getCoinImage();
            this.balanceBox = new BalanceCounter(this, this.config.balance(), this.config.currencyName(), image);
            this.infoBoxManager.addInfoBox((InfoBox)this.balanceBox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getCoinImage() {
        if (this.config.cointype() == CoinType.CUSTOM) {
            try {
                Class<ImageIO> clazz = ImageIO.class;
                synchronized (ImageIO.class) {
                    BufferedImage image = ImageIO.read(CUSTOM_COIN_IMAGE);
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return image;
                }
            }
            catch (IOException e) {
                log.error("error loading custom coin image", (Throwable)e);
            }
        }
        return this.itemManager.getImage(this.getItemIdForCoin(this.config.cointype()), this.config.balance() * 100, false);
    }

    private int getItemIdForCoin(CoinType coin) {
        switch (coin) {
            case COINS: {
                return 995;
            }
            case BLOOD_MONEY: {
                return 13307;
            }
            case PURPLE_SWEETS: {
                return 10476;
            }
            case HALLOWED_MARK: {
                return 24711;
            }
            case MARK_OF_GRACE: {
                return 11849;
            }
            case COLLECTION_LOG: {
                return 22711;
            }
            case PIECES_OF_EIGHT: {
                return 8951;
            }
            case GOLDEN_NUGGET: {
                return 12012;
            }
            case PLATINUM_TOKEN: {
                return 13204;
            }
            case TOKKUL: {
                return 6529;
            }
            case WARRIOR_GUILD_TOKEN: {
                return 8851;
            }
        }
        return this.getItemIdForCoin(CoinType.COINS);
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        IntegerArgument arg = this.getIntegerFromCommandArguments(commandExecuted.getArguments());
        switch (commandExecuted.getCommand().toLowerCase()) {
            case "count": {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You have " + this.config.balance() + " " + this.config.currencyName(), null);
                break;
            }
            case "add": {
                if (!arg.isValid()) break;
                int increment = arg.getValue();
                this.incrementBalance(increment);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You now have " + this.config.balance() + " " + this.config.currencyName(), null);
                break;
            }
            case "subtract": 
            case "remove": {
                if (!arg.isValid()) break;
                int sub = Integer.parseInt(commandExecuted.getArguments()[0]);
                this.incrementBalance(-sub);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You now have " + this.config.balance() + " " + this.config.currencyName(), null);
                break;
            }
            case "set": {
                if (!arg.isValid()) break;
                int amount = Integer.parseInt(commandExecuted.getArguments()[0]);
                this.setBalance(amount);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You now have " + this.config.balance() + " " + this.config.currencyName(), null);
                break;
            }
            case "clearxp": {
                this.config.setXpSinceReward(0);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "XP since last reward set to 0.", null);
                break;
            }
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        int xp = statChanged.getXp();
        if (this.ticksSinceLogin > 0) {
            int deltaXP = xp - this.skillXPs.get(skill);
            this.config.setXpSinceReward(this.config.xpSinceReward() + deltaXP);
            this.skillXPs.put(skill, xp);
            int xpSinceReward = this.config.xpSinceReward();
            int xpRewardInterval = this.config.xpRewardInterval();
            if (xpRewardInterval > 0 && xpSinceReward >= xpRewardInterval) {
                int numRewards = xpSinceReward / xpRewardInterval;
                int reward = numRewards * this.config.xpReward();
                this.incrementBalance(numRewards * this.config.xpReward());
                int newBalance = this.config.balance();
                int remainingXP = xpSinceReward % xpRewardInterval;
                this.config.setXpSinceReward(remainingXP);
            }
        } else {
            this.skillXPs.put(statChanged.getSkill(), statChanged.getXp());
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        ++this.ticksSinceLogin;
    }

    private IntegerArgument getIntegerFromCommandArguments(String[] args) {
        if (args.length == 0) {
            return new IntegerArgument(0, false);
        }
        String firstArg = args[0];
        try {
            return new IntegerArgument(Integer.parseInt(firstArg), true);
        }
        catch (NumberFormatException e) {
            log.error("Malformed Argument for a PersonalCurrencyTracker Command");
            return new IntegerArgument(0, false);
        }
    }

    private void updateNPCKillRewardMap(String configStr) throws IllegalArgumentException {
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        if (!configStr.equals("")) {
            String[] pairs;
            for (String s : pairs = configStr.split(",")) {
                if (!s.contains("#")) continue;
                String[] pair = s.trim().toLowerCase().split("#");
                if (pair.length != 2) {
                    String msg = "PersonalCurrencyTracker: An (NPC, Kill-Reward) pair has more than 2 components!";
                    log.error(msg);
                    throw new IllegalArgumentException(msg);
                }
                tempMap.put(pair[0].trim(), Integer.parseInt(pair[1].trim()));
            }
        }
        this.npcRewardsMap = tempMap;
    }

    @Provides
    PersonalCurrencyTrackerConfig provideConfig(ConfigManager configManager) {
        return (PersonalCurrencyTrackerConfig)configManager.getConfig(PersonalCurrencyTrackerConfig.class);
    }

    private class IntegerArgument {
        private final boolean valid;
        private final int value;

        public IntegerArgument(int val, boolean isValid) {
            this.valid = isValid;
            this.value = val;
        }

        public boolean isValid() {
            return this.valid;
        }

        public int getValue() {
            return this.value;
        }
    }
}

