/*
 * Decompiled with CFR 0.152.
 */
package com.creativetechguy;

import com.creativetechguy.TreeConfig;
import com.creativetechguy.TreeDespawnTimerConfig;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;

public class TreeState {
    WorldPoint worldPoint;
    Point centerOffset;
    HashSet<Player> playersChopping = new HashSet();
    List<WorldPoint> points;
    String treeName;
    boolean hasUnrenderedPlayersChopping = false;
    boolean haveYouChoppedLog = false;
    boolean hideTree = false;
    private int ticksLeft;
    private final int maxTicks;
    private final Client client;
    private final TreeDespawnTimerConfig config;

    public TreeState(GameObject tree, Client client, TreeDespawnTimerConfig config) {
        this.worldPoint = tree.getWorldLocation();
        this.client = client;
        this.config = config;
        TreeConfig treeConfig = TreeConfig.getTreeById(tree.getId());
        this.treeName = treeConfig.name();
        this.ticksLeft = this.maxTicks = treeConfig.getMaxTicks();
        this.centerOffset = this.getCenterOffset(tree);
        this.points = this.getPoints(tree);
    }

    int getTickDelta() {
        if (!this.playersChopping.isEmpty() || this.hasUnrenderedPlayersChopping) {
            if ((this.playersChopping.size() >= 2 || !this.playersChopping.contains(this.client.getLocalPlayer()) || this.haveYouChoppedLog || this.hasUnrenderedPlayersChopping) && this.ticksLeft > 0) {
                return -1;
            }
        } else if (this.ticksLeft < this.maxTicks) {
            return 1;
        }
        return 0;
    }

    void tick() {
        this.ticksLeft += this.getTickDelta();
    }

    boolean shouldShowTimer() {
        if (this.hideTree) {
            return false;
        }
        if (this.playersChopping.size() > 0) {
            return true;
        }
        return this.ticksLeft < this.maxTicks;
    }

    Color getTimerColor() {
        if (this.hideTree) {
            return Color.GRAY;
        }
        double percent = this.getTimePercent().floatValue() * 100.0f;
        if (percent < 15.0) {
            return this.config.timerColorLow();
        }
        if (percent < 40.0) {
            return this.config.timerColorMedium();
        }
        if (percent < 80.0) {
            return this.config.timerColorHigh();
        }
        return this.config.timerColorFull();
    }

    Float getTimePercent() {
        return Float.valueOf(Math.max((float)this.ticksLeft / (float)this.maxTicks, 0.0f));
    }

    Integer getTimeTicks() {
        return Math.max(this.ticksLeft, 0);
    }

    Integer getTimeSeconds(int subTickMs) {
        return Math.max((int)Math.floor((float)(this.ticksLeft * 600 + subTickMs * this.getTickDelta()) / 1000.0f), 0);
    }

    private List<WorldPoint> getPoints(GameObject gameObject) {
        WorldPoint maxPoint;
        WorldPoint minPoint = this.getSWWorldPoint(gameObject);
        if (minPoint.equals((Object)(maxPoint = this.getNEWorldPoint(gameObject)))) {
            return Collections.singletonList(minPoint);
        }
        int plane = minPoint.getPlane();
        ArrayList<WorldPoint> list = new ArrayList<WorldPoint>();
        for (int x = minPoint.getX(); x <= maxPoint.getX(); ++x) {
            for (int y = minPoint.getY(); y <= maxPoint.getY(); ++y) {
                list.add(new WorldPoint(x, y, plane));
            }
        }
        return list;
    }

    private Point getCenterOffset(GameObject gameObject) {
        int x = 0;
        int y = 0;
        if (gameObject.sizeX() % 2 == 0) {
            x = (gameObject.sizeX() - 1) * 64;
        }
        if (gameObject.sizeY() % 2 == 0) {
            y = (gameObject.sizeY() - 1) * 64;
        }
        return new Point(x, y);
    }

    private WorldPoint getSWWorldPoint(GameObject gameObject) {
        return this.getWorldPoint(gameObject, GameObject::getSceneMinLocation);
    }

    private WorldPoint getNEWorldPoint(GameObject gameObject) {
        return this.getWorldPoint(gameObject, GameObject::getSceneMaxLocation);
    }

    private WorldPoint getWorldPoint(GameObject gameObject, Function<GameObject, Point> pointFunction) {
        Point point = pointFunction.apply(gameObject);
        return WorldPoint.fromScene((Client)this.client, (int)point.getX(), (int)point.getY(), (int)gameObject.getPlane());
    }

    public boolean canShowPopularIndicator() {
        int regionID = this.worldPoint.getRegionID();
        return regionID != 6198 && regionID != 6454;
    }
}

